/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.MainLogicDefinition;
import com.flipkart.krystal.krystex.RequestId;
import com.flipkart.krystal.krystex.commands.ExecuteWithAllInputs;
import com.flipkart.krystal.krystex.commands.NodeCommand;
import com.flipkart.krystal.krystex.decoration.LogicDecorationOrdering;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.Node;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeDefinitionRegistry;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.krystex.node.NodeRegistry;
import com.flipkart.krystal.krystex.node.NodeResponseFuture;
import com.flipkart.krystal.logic.LogicTag;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KrystalNodeExecutor
implements KrystalExecutor {
    private static final Logger log = LoggerFactory.getLogger(KrystalNodeExecutor.class);
    private final NodeDefinitionRegistry nodeDefinitionRegistry;
    private final LogicDecorationOrdering logicDecorationOrdering;
    private final ExecutorService commandQueue;
    private final RequestId requestId;
    private final Map<String, Map<String, MainLogicDecorator>> requestScopedMainDecorators = new LinkedHashMap<String, Map<String, MainLogicDecorator>>();
    private final NodeRegistry nodeRegistry = new NodeRegistry();

    public KrystalNodeExecutor(NodeDefinitionRegistry nodeDefinitionRegistry, LogicDecorationOrdering logicDecorationOrdering, String requestId) {
        this.nodeDefinitionRegistry = nodeDefinitionRegistry;
        this.logicDecorationOrdering = logicDecorationOrdering;
        this.commandQueue = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("KrystalTaskExecutorMainThread-%s".formatted(requestId)).build());
        this.requestId = new RequestId(requestId);
    }

    private ImmutableMap<String, MainLogicDecorator> getRequestScopedDecorators(NodeLogicId nodeLogicId) {
        MainLogicDefinition mainLogicDefinition = this.nodeDefinitionRegistry.logicDefinitionRegistry().getMain(nodeLogicId);
        LinkedHashMap decorators = new LinkedHashMap();
        mainLogicDefinition.getRequestScopedLogicDecoratorConfigs().forEach((s, decoratorConfig) -> {
            if (decoratorConfig.shouldDecorate().test((ImmutableMap<String, LogicTag>)mainLogicDefinition.logicTags())) {
                String instanceId = decoratorConfig.instanceIdGenerator().apply((ImmutableMap<String, LogicTag>)mainLogicDefinition.logicTags());
                decorators.put(s, this.requestScopedMainDecorators.computeIfAbsent((String)s, k -> new LinkedHashMap()).computeIfAbsent(instanceId, k -> decoratorConfig.factory().apply((String)k)));
            }
        });
        return ImmutableMap.copyOf(decorators);
    }

    @Override
    public <T> CompletableFuture<T> executeNode(NodeId nodeId, Inputs inputs) {
        return this.executeNode(nodeId, inputs, this.requestId);
    }

    public <T> CompletableFuture<T> executeNode(NodeId nodeId, Inputs inputs, String requestId) {
        return this.executeNode(nodeId, inputs, new RequestId(requestId));
    }

    CompletableFuture<?> executeNode(NodeId nodeId, Inputs inputs, RequestId requestId) {
        NodeResponseFuture responseFuture;
        if (inputs.values().isEmpty()) {
            responseFuture = this.enqueueCommand(new ExecuteWithAllInputs(nodeId, Inputs.empty(), requestId));
        } else {
            ExecuteWithAllInputs executeWithInputs = new ExecuteWithAllInputs(nodeId, inputs, requestId);
            responseFuture = this.enqueueCommand(executeWithInputs);
        }
        return responseFuture.responseFuture().thenApply(valueOrError -> {
            if (valueOrError.error().isPresent()) {
                throw new RuntimeException((Throwable)valueOrError.error().get());
            }
            return valueOrError.value().orElse(null);
        });
    }

    NodeResponseFuture enqueueCommand(NodeCommand nodeCommand) {
        NodeResponseFuture result = new NodeResponseFuture();
        CompletableFuture<NodeResponseFuture> nodeResponseFutureCompletableFuture = CompletableFuture.supplyAsync(() -> this.execute(nodeCommand), this.commandQueue);
        nodeResponseFutureCompletableFuture.whenComplete((nodeResponseFuture, e) -> {
            if (e == null) {
                nodeResponseFuture.responseFuture().whenComplete((o, t) -> {
                    if (t == null) {
                        result.responseFuture().complete((ValueOrError<Object>)o);
                    } else {
                        result.responseFuture().completeExceptionally((Throwable)t);
                    }
                });
            } else {
                result.responseFuture().completeExceptionally((Throwable)e);
            }
        });
        return result;
    }

    private NodeResponseFuture execute(NodeCommand nodeCommand) {
        NodeId nodeId = nodeCommand.nodeId();
        Node node = this.nodeRegistry.createIfAbsent(nodeId, n -> {
            NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.get((NodeId)n);
            return new Node(nodeDefinition, this, this.getRequestScopedDecorators(nodeDefinition.mainLogicNode()), this.logicDecorationOrdering);
        });
        return node.executeCommand(nodeCommand);
    }

    @Override
    public void close() {
        this.commandQueue.shutdown();
    }
}

