/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.decorators;

import com.flipkart.krystal.krystex.MainLogic;
import com.flipkart.krystal.krystex.config.ConfigProvider;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerStateMachine;
import io.github.resilience4j.decorators.Decorators;
import java.util.Optional;

public final class Resilience4JCircuitBreaker
implements MainLogicDecorator {
    public static final String DECORATOR_TYPE = Resilience4JCircuitBreaker.class.getName();
    private final ConfigProvider configProvider;
    private final String instanceId;
    private CircuitBreaker circuitBreaker;

    public Resilience4JCircuitBreaker(String instanceId, ConfigProvider configProvider) {
        this.instanceId = instanceId;
        this.configProvider = configProvider;
        this.init();
    }

    @Override
    public MainLogic<Object> decorateLogic(MainLogic<Object> logicToDecorate) {
        CircuitBreaker circuitBreaker = this.circuitBreaker;
        if (circuitBreaker != null) {
            return arg_0 -> ((Decorators.DecorateFunction)Decorators.ofFunction(logicToDecorate::execute).withCircuitBreaker(circuitBreaker)).apply(arg_0);
        }
        return logicToDecorate;
    }

    @Override
    public void onConfigUpdate() {
        this.updateCircuitBreaker();
    }

    @Override
    public String getId() {
        return this.instanceId;
    }

    private void init() {
        this.circuitBreaker = this.getCircuitBreakerConfig().map(config -> new CircuitBreakerStateMachine(this.instanceId + ".circuit_breaker", config)).orElse(null);
    }

    private Optional<CircuitBreakerConfig> getCircuitBreakerConfig() {
        boolean circuitBreakerEnabled = this.configProvider.getConfig(this.instanceId + ".circuit_breaker.enabled").orElse(true);
        if (!circuitBreakerEnabled) {
            return Optional.empty();
        }
        return Optional.of(CircuitBreakerConfig.ofDefaults());
    }

    private void updateCircuitBreaker() {
        CircuitBreaker circuitBreaker = this.circuitBreaker;
        Optional<CircuitBreakerConfig> newConfig = this.getCircuitBreakerConfig();
        if (!Optional.ofNullable(circuitBreaker).map(CircuitBreaker::getCircuitBreakerConfig).equals(newConfig)) {
            this.init();
        }
    }
}

