/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex;

import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.LogicDefinition;
import com.flipkart.krystal.krystex.decoration.MainLogicDecorator;
import com.flipkart.krystal.krystex.decoration.MainLogicDecoratorConfig;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.logic.LogicTag;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MainLogicDefinition<T>
extends LogicDefinition {
    private final Map<String, MainLogicDecoratorConfig> requestScopedLogicDecoratorConfigs = new HashMap<String, MainLogicDecoratorConfig>();
    private final Map<String, MainLogicDecorator> sessionScopedLogicDecorators = new HashMap<String, MainLogicDecorator>();

    public MainLogicDefinition(NodeLogicId nodeLogicId, Set<String> inputs, ImmutableMap<String, LogicTag> logicTags) {
        super(nodeLogicId, inputs, logicTags);
    }

    public abstract ImmutableMap<Inputs, CompletableFuture<T>> execute(ImmutableList<Inputs> var1);

    public ImmutableMap<String, MainLogicDecoratorConfig> getRequestScopedLogicDecoratorConfigs() {
        return ImmutableMap.copyOf(this.requestScopedLogicDecoratorConfigs);
    }

    public Map<String, MainLogicDecorator> getSessionScopedLogicDecorators() {
        return ImmutableMap.copyOf(this.sessionScopedLogicDecorators);
    }

    public void registerRequestScopedDecorator(MainLogicDecoratorConfig decoratorConfig) {
        this.requestScopedLogicDecoratorConfigs.put(decoratorConfig.decoratorType(), decoratorConfig);
    }

    public void registerSessionScopedLogicDecorator(MainLogicDecorator logicDecorator) {
        this.sessionScopedLogicDecorators.put(logicDecorator.decoratorType(), logicDecorator);
    }
}

