/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.krystex.KrystalExecutor;
import com.flipkart.krystal.krystex.RequestId;
import com.flipkart.krystal.krystex.commands.ExecuteInputless;
import com.flipkart.krystal.krystex.commands.ExecuteWithInput;
import com.flipkart.krystal.krystex.commands.NodeCommand;
import com.flipkart.krystal.krystex.node.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.MainLogicDefinition;
import com.flipkart.krystal.krystex.node.Node;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeDefinitionRegistry;
import com.flipkart.krystal.krystex.node.NodeGroupId;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.krystex.node.NodeRegistry;
import com.flipkart.krystal.krystex.node.NodeResponseFuture;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KrystalNodeExecutor
implements KrystalExecutor {
    private static final Logger log = LoggerFactory.getLogger(KrystalNodeExecutor.class);
    private final NodeDefinitionRegistry nodeDefinitionRegistry;
    private final ExecutorService commandQueue;
    private final RequestId requestId;
    private final Map<DecoratorKey, MainLogicDecorator<?>> requestScopedNodeDecorators = new HashMap();
    private final NodeRegistry nodeRegistry = new NodeRegistry();

    public KrystalNodeExecutor(NodeDefinitionRegistry nodeDefinitionRegistry, String requestId) {
        this.nodeDefinitionRegistry = nodeDefinitionRegistry;
        this.commandQueue = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("KrystalTaskExecutorMainThread-%s".formatted(requestId)).build());
        this.requestId = new RequestId(requestId);
    }

    private <T> ImmutableList<MainLogicDecorator<T>> getRequestScopedNodeDecorators(NodeLogicId nodeLogicId) {
        MainLogicDefinition mainLogicDefinition = this.nodeDefinitionRegistry.logicDefinitionRegistry().getMain(nodeLogicId);
        List<MainLogicDecorator> decorators = mainLogicDefinition.getRequestScopedNodeDecoratorFactories().values().stream().map(Supplier::get).toList();
        return ImmutableList.copyOf(decorators);
    }

    @Override
    public <T> CompletableFuture<T> executeNode(NodeId nodeId, Inputs nodeInputs) {
        return this.executeNode(nodeId, nodeInputs, this.requestId).responseFuture();
    }

    public <T> CompletableFuture<T> executeNode(NodeId nodeId, Inputs nodeInputs, String requestId) {
        return this.executeNode(nodeId, nodeInputs, new RequestId(requestId)).responseFuture();
    }

    NodeResponseFuture executeNode(NodeId nodeId, Inputs nodeInputs, RequestId requestId) {
        if (nodeInputs.values().isEmpty()) {
            return this.enqueueCommand(new ExecuteInputless(nodeId, requestId));
        }
        ArrayList<NodeResponseFuture> list = new ArrayList<NodeResponseFuture>();
        for (Map.Entry e : nodeInputs.values().entrySet()) {
            ExecuteWithInput executeWithInput = new ExecuteWithInput(nodeId, (String)e.getKey(), (InputValue)e.getValue(), requestId);
            list.add(this.enqueueCommand(executeWithInput));
        }
        return (NodeResponseFuture)list.stream().findAny().orElseThrow();
    }

    public NodeResponseFuture enqueueCommand(NodeCommand nodeCommand) {
        NodeResponseFuture result = new NodeResponseFuture();
        CompletableFuture<NodeResponseFuture> nodeResponseFutureCompletableFuture = CompletableFuture.supplyAsync(() -> this.execute(nodeCommand), this.commandQueue);
        nodeResponseFutureCompletableFuture.whenComplete((nodeResponseFuture, e) -> {
            if (e == null) {
                nodeResponseFuture.responseFuture().whenComplete((o, t) -> {
                    result.inputsFuture().complete(nodeResponseFuture.inputsFuture().getNow(null));
                    if (t == null) {
                        result.responseFuture().complete(o);
                    } else {
                        result.responseFuture().completeExceptionally((Throwable)t);
                    }
                });
            } else {
                result.responseFuture().completeExceptionally((Throwable)e);
            }
        });
        return result;
    }

    private NodeResponseFuture execute(NodeCommand nodeCommand) {
        NodeId nodeId = nodeCommand.nodeId();
        Node node = this.nodeRegistry.createIfAbsent(nodeId, n -> {
            NodeDefinition nodeDefinition = this.nodeDefinitionRegistry.get((NodeId)n);
            ImmutableMap nodeDecorators = ImmutableMap.of((Object)nodeDefinition.mainLogicNode(), this.getRequestScopedNodeDecorators(nodeDefinition.mainLogicNode()));
            return new Node(nodeDefinition, this, (ImmutableMap<NodeLogicId, ImmutableList<MainLogicDecorator<Object>>>)nodeDecorators);
        });
        return node.executeCommand(nodeCommand);
    }

    @Override
    public void close() {
        this.commandQueue.shutdown();
    }

    private record DecoratorKey(NodeGroupId nodeGroupId, String nodeDecoratorId) {
    }
}

