/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.krystex.node;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Inputs;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.flipkart.krystal.krystex.RequestId;
import com.flipkart.krystal.krystex.ResolverDefinition;
import com.flipkart.krystal.krystex.commands.ExecuteInputless;
import com.flipkart.krystal.krystex.commands.ExecuteWithInput;
import com.flipkart.krystal.krystex.commands.NodeCommand;
import com.flipkart.krystal.krystex.commands.SkipNode;
import com.flipkart.krystal.krystex.node.DuplicateInputForRequestException;
import com.flipkart.krystal.krystex.node.KrystalNodeExecutor;
import com.flipkart.krystal.krystex.node.MainLogic;
import com.flipkart.krystal.krystex.node.MainLogicDecorator;
import com.flipkart.krystal.krystex.node.MainLogicDefinition;
import com.flipkart.krystal.krystex.node.NodeDefinition;
import com.flipkart.krystal.krystex.node.NodeId;
import com.flipkart.krystal.krystex.node.NodeLogicId;
import com.flipkart.krystal.krystex.node.NodeResponseFuture;
import com.flipkart.krystal.krystex.node.ResolverCommand;
import com.flipkart.krystal.krystex.node.SkipNodeException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Node {
    private final NodeId nodeId;
    private final NodeDefinition nodeDefinition;
    private final KrystalNodeExecutor krystalNodeExecutor;
    private final ImmutableMap<NodeLogicId, ImmutableList<MainLogicDecorator<Object>>> nodeDecorators;
    private final ImmutableMap<Optional<String>, List<ResolverDefinition>> resolverDefinitionsByInput;
    private final Map<RequestId, Map<String, InputValue<?>>> inputsValueCollector = new LinkedHashMap();
    private final Map<RequestId, NodeResponseFuture> resultsByRequest = new LinkedHashMap<RequestId, NodeResponseFuture>();
    private final Map<Inputs, NodeResponseFuture> resultsCache = new LinkedHashMap<Inputs, NodeResponseFuture>();
    private final Map<RequestId, Map<NodeLogicId, ResolverCommand>> resolverResults = new LinkedHashMap<RequestId, Map<NodeLogicId, ResolverCommand>>();

    public Node(NodeDefinition nodeDefinition, KrystalNodeExecutor krystalNodeExecutor, ImmutableMap<NodeLogicId, ImmutableList<MainLogicDecorator<Object>>> nodeDecorators) {
        this.nodeId = nodeDefinition.nodeId();
        this.nodeDefinition = nodeDefinition;
        this.krystalNodeExecutor = krystalNodeExecutor;
        this.nodeDecorators = nodeDecorators;
        this.resolverDefinitionsByInput = Node.createResolverDefinitionsByInputs(nodeDefinition.resolverDefinitions());
    }

    public NodeResponseFuture executeCommand(NodeCommand nodeCommand) {
        RequestId requestId = nodeCommand.requestId();
        NodeResponseFuture resultForRequest = this.resultsByRequest.computeIfAbsent(requestId, r -> new NodeResponseFuture());
        try {
            boolean executeMainLogic;
            NodeLogicId mainLogicNode = this.nodeDefinition.mainLogicNode();
            MainLogicDefinition mainLogicNodeDefinition = this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getMain(mainLogicNode);
            if (nodeCommand instanceof SkipNode) {
                SkipNode skipNode = (SkipNode)nodeCommand;
                resultForRequest.responseFuture().completeExceptionally(new SkipNodeException(skipNode.reason()));
                return resultForRequest;
            }
            if (nodeCommand instanceof ExecuteInputless) {
                ExecuteInputless executeInputless = (ExecuteInputless)nodeCommand;
                executeMainLogic = this.executeNodeWithNoInputs(executeInputless, requestId);
            } else if (nodeCommand instanceof ExecuteWithInput) {
                ExecuteWithInput executeWithInput = (ExecuteWithInput)nodeCommand;
                executeMainLogic = this.executeWithInput(requestId, executeWithInput);
            } else {
                throw new UnsupportedOperationException("Unknown type of nodeCommand: %s".formatted(nodeCommand));
            }
            if (executeMainLogic) {
                Inputs inputs = new Inputs((Map)this.inputsValueCollector.getOrDefault(requestId, (Map<String, InputValue<?>>)ImmutableMap.of()));
                NodeResponseFuture mainLogicResponse = this.resultsCache.computeIfAbsent(inputs, i -> {
                    NodeResponseFuture newResult = new NodeResponseFuture();
                    Node.executeMainLogic(inputs, mainLogicNodeDefinition, (ImmutableList<MainLogicDecorator<Object>>)((ImmutableList)this.nodeDecorators.getOrDefault((Object)mainLogicNode, (Object)ImmutableList.of()))).whenComplete((r, t) -> {
                        newResult.inputsFuture().complete(new Inputs(Maps.filterKeys((Map)inputs.values(), input -> !this.nodeDefinition.dependencyNodes().containsKey(input))));
                        if (t != null) {
                            newResult.responseFuture().completeExceptionally((Throwable)t);
                        } else {
                            newResult.responseFuture().complete(r);
                        }
                    });
                    return newResult;
                });
                mainLogicResponse.responseFuture().whenComplete((o, t) -> {
                    resultForRequest.inputsFuture().complete(mainLogicResponse.inputsFuture().getNow(null));
                    if (t != null) {
                        resultForRequest.responseFuture().completeExceptionally((Throwable)t);
                    } else {
                        resultForRequest.responseFuture().complete(o);
                    }
                });
            }
        }
        catch (DuplicateInputForRequestException e) {
            throw e;
        }
        catch (Exception e) {
            resultForRequest.responseFuture().obtrudeException(e);
        }
        return resultForRequest;
    }

    private boolean executeNodeWithNoInputs(ExecuteInputless executeInputless, RequestId requestId) {
        MainLogicDefinition mainLogicNodeDefinition = this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getMain(this.nodeDefinition.mainLogicNode());
        ImmutableSet inputNames = mainLogicNodeDefinition.inputNames();
        if (inputNames.isEmpty()) {
            return true;
        }
        if (this.nodeDefinition.resolverDefinitions().isEmpty() && !this.nodeDefinition.dependencyNodes().isEmpty()) {
            this.nodeDefinition.dependencyNodes().forEach((depName, nodeId) -> {
                RequestId dependencyRequestId = requestId.append("(%s)%s[%s]".formatted(depName, nodeId, 0));
                if (!((Map)this.inputsValueCollector.getOrDefault(requestId, (Map<String, InputValue<?>>)ImmutableMap.of())).containsKey(depName)) {
                    this.krystalNodeExecutor.executeNode((NodeId)nodeId, Inputs.empty(), dependencyRequestId).responseFuture().whenComplete((o, throwable) -> this.krystalNodeExecutor.enqueueCommand(new ExecuteWithInput(executeInputless.nodeId(), (String)depName, (InputValue<?>)ValueOrError.valueOrError((Object)o, (Throwable)throwable), requestId)));
                }
            });
            return false;
        }
        return this.executeWithInput(requestId, (String)null);
    }

    private boolean executeWithInput(RequestId requestId, ExecuteWithInput executeWithInput) {
        String input = executeWithInput.name();
        InputValue<?> inputValue = executeWithInput.inputValue();
        if (this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap()).putIfAbsent(input, inputValue) != null) {
            throw new DuplicateInputForRequestException("Duplicate input data for a request %s".formatted(requestId));
        }
        return this.executeWithInput(requestId, input);
    }

    private boolean executeWithInput(RequestId requestId, @Nullable String input) {
        Map inputs = this.inputsValueCollector.computeIfAbsent(requestId, r -> new LinkedHashMap());
        MainLogicDefinition mainLogicNodeDefinition = this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getMain(this.nodeDefinition.mainLogicNode());
        this.resultsByRequest.computeIfAbsent(requestId, r -> new NodeResponseFuture());
        Map nodeResults = this.resolverResults.computeIfAbsent(requestId, r -> new LinkedHashMap());
        Iterable pendingResolvers = ((List)this.resolverDefinitionsByInput.getOrDefault(Optional.ofNullable(input), (Object)ImmutableList.of())).stream().filter(resolverDefinition1 -> !nodeResults.containsKey(resolverDefinition1.resolverNodeLogicId()))::iterator;
        int pendingResolverCount = 0;
        for (ResolverDefinition resolverDefinition : pendingResolvers) {
            ++pendingResolverCount;
            String dependencyName = resolverDefinition.dependencyName();
            ImmutableSet<String> boundFrom = resolverDefinition.boundFrom();
            NodeLogicId nodeLogicId = resolverDefinition.resolverNodeLogicId();
            if (!boundFrom.stream().allMatch(inputs::containsKey)) continue;
            Inputs inputResolverInputs = new Inputs(Maps.filterKeys((Map)inputs, arg_0 -> boundFrom.contains(arg_0)));
            ResolverCommand resolverCommand = this.nodeDefinition.nodeDefinitionRegistry().logicDefinitionRegistry().getResolver(nodeLogicId).resolve(inputResolverInputs);
            nodeResults.put(nodeLogicId, resolverCommand);
            NodeId nodeId = (NodeId)this.nodeDefinition.dependencyNodes().get((Object)dependencyName);
            int counter = 0;
            LinkedHashMap<RequestId, NodeResponseFuture> dependencyResults = new LinkedHashMap<RequestId, NodeResponseFuture>();
            for (Inputs nodeInputs : resolverCommand.getInputs()) {
                RequestId dependencyRequestId = requestId.append("(%s)%s[%s]".formatted(dependencyName, nodeId, counter++));
                for (String dependencyInput : resolverDefinition.resolvedInputNames()) {
                    dependencyResults.putIfAbsent(dependencyRequestId, this.krystalNodeExecutor.enqueueCommand(new ExecuteWithInput(nodeId, dependencyInput, (InputValue<?>)nodeInputs.getInputValue(dependencyInput), dependencyRequestId)));
                }
            }
            if (resolverCommand instanceof ResolverCommand.SkipDependency) {
                this.krystalNodeExecutor.enqueueCommand(new ExecuteWithInput(this.nodeId, dependencyName, (InputValue<?>)Results.empty(), requestId));
                continue;
            }
            CompletableFuture.allOf((CompletableFuture[])dependencyResults.values().stream().map(NodeResponseFuture::responseFuture).toArray(CompletableFuture[]::new)).whenComplete((unused, throwable) -> {
                ImmutableMap aggregate = ImmutableMap.of();
                if (throwable == null) {
                    aggregate = (ImmutableMap)dependencyResults.values().stream().collect(ImmutableMap.toImmutableMap(nrf -> nrf.inputsFuture().getNow(null), nrf -> {
                        try {
                            return ValueOrError.withValue(nrf.responseFuture().getNow(null));
                        }
                        catch (Exception e) {
                            return ValueOrError.error((Throwable)e);
                        }
                    }));
                }
                this.krystalNodeExecutor.enqueueCommand(new ExecuteWithInput(this.nodeId, dependencyName, (InputValue<?>)new Results(aggregate), requestId));
            });
        }
        boolean executeMainLogic = false;
        if (pendingResolverCount == 0) {
            ImmutableSet inputNames = mainLogicNodeDefinition.inputNames();
            if (((Map)this.inputsValueCollector.getOrDefault(requestId, (Map<String, InputValue<?>>)ImmutableMap.of())).keySet().containsAll((Collection<?>)inputNames)) {
                executeMainLogic = true;
            }
        }
        return executeMainLogic;
    }

    private static CompletableFuture<?> executeMainLogic(Inputs inputs, MainLogicDefinition<Object> mainLogicDefinition, ImmutableList<MainLogicDecorator<Object>> mainLogicDecorators) {
        MainLogic<Object> logic = mainLogicDefinition::execute;
        for (MainLogicDecorator mainLogicDecorator : mainLogicDecorators) {
            logic = mainLogicDecorator.decorateLogic(mainLogicDefinition, logic);
        }
        return (CompletableFuture)logic.execute((ImmutableList<Inputs>)ImmutableList.of((Object)inputs)).get((Object)inputs);
    }

    private static ImmutableMap<Optional<String>, List<ResolverDefinition>> createResolverDefinitionsByInputs(ImmutableList<ResolverDefinition> resolverDefinitions) {
        LinkedHashMap resolverDefinitionsByInput = new LinkedHashMap();
        resolverDefinitions.forEach(resolverDefinition -> {
            if (!resolverDefinition.boundFrom().isEmpty()) {
                resolverDefinition.boundFrom().forEach(input -> resolverDefinitionsByInput.computeIfAbsent(Optional.of(input), s -> new ArrayList()).add(resolverDefinition));
            } else {
                resolverDefinitionsByInput.computeIfAbsent(Optional.empty(), s -> new ArrayList()).add(resolverDefinition);
            }
        });
        return ImmutableMap.copyOf(resolverDefinitionsByInput);
    }
}

