/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.visualization;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class StaticCallGraphHtml {
    private static final String TEMPLATE_PATH = "/templates/graph.html";
    private static final String STATIC_PATH = "/static";
    private static final String JS_PATH = "/static/js";
    private static final String CSS_PLACEHOLDER = "__CSS_CONTENT__";
    private static final String DATA_PLACEHOLDER = "__GRAPH_DATA__";
    private static final String MAIN_JS_PLACEHOLDER = "__MAIN_JS__";
    private static final String CONFIG_JS_PLACEHOLDER = "__CONFIG_JS__";
    private static final String DATA_PROCESSOR_JS_PLACEHOLDER = "__DATA_PROCESSOR_JS__";
    private static final String GRAPH_RENDERER_JS_PLACEHOLDER = "__GRAPH_RENDERER_JS__";
    private static final String NODE_CONTROLLER_JS_PLACEHOLDER = "__NODE_CONTROLLER_JS__";
    private static final String SEARCH_CONTROLLER_JS_PLACEHOLDER = "__SEARCH_CONTROLLER_JS__";
    private static final String TOOLTIP_JS_PLACEHOLDER = "__TOOLTIP_JS__";
    private static final String INTERACTION_HANDLER_JS_PLACEHOLDER = "__INTERACTION_HANDLER_JS__";
    private static final Pattern D3_IMPORT = Pattern.compile("import \\* as d3 from.*?;");
    private static final Pattern D3_DAG_IMPORT = Pattern.compile("import \\* as d3dag from.*?;");
    private static final Pattern JS_FILE_IMPORT = Pattern.compile("import \\{ .+? } from ['\"]\\./(.+?)\\.js['\"];");
    private static final Pattern EXPORT_FUNC_CLASS = Pattern.compile("export (class|function) (\\w+)");
    private static final Pattern EXPORT_CONST = Pattern.compile("export const ([\\w_]+) =");

    private static String loadTemplate() {
        String string;
        InputStream inputStream = StaticCallGraphHtml.class.getResourceAsStream(TEMPLATE_PATH);
        if (inputStream == null) {
            throw new RuntimeException("Template file not found in /templates/graph.html");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading template", e);
            }
        }
        reader.close();
        return string;
    }

    static String generateStaticCallGraphHtml(String jsonGraphData) {
        try {
            String template = StaticCallGraphHtml.loadTemplate();
            template = template.replace(DATA_PLACEHOLDER, jsonGraphData);
            String cssContent = StaticCallGraphHtml.loadResourceContent("/static/styles.css");
            template = template.replace(CSS_PLACEHOLDER, cssContent);
            HashMap<String, String> jsFilePlaceholders = new HashMap<String, String>();
            jsFilePlaceholders.put(MAIN_JS_PLACEHOLDER, "/static/js/main.js");
            jsFilePlaceholders.put(CONFIG_JS_PLACEHOLDER, "/static/js/config.js");
            jsFilePlaceholders.put(DATA_PROCESSOR_JS_PLACEHOLDER, "/static/js/dataProcessor.js");
            jsFilePlaceholders.put(GRAPH_RENDERER_JS_PLACEHOLDER, "/static/js/graphRenderer.js");
            jsFilePlaceholders.put(NODE_CONTROLLER_JS_PLACEHOLDER, "/static/js/nodeController.js");
            jsFilePlaceholders.put(SEARCH_CONTROLLER_JS_PLACEHOLDER, "/static/js/searchController.js");
            jsFilePlaceholders.put(TOOLTIP_JS_PLACEHOLDER, "/static/js/tooltip.js");
            jsFilePlaceholders.put(INTERACTION_HANDLER_JS_PLACEHOLDER, "/static/js/interactionHandler.js");
            for (Map.Entry entry : jsFilePlaceholders.entrySet()) {
                String placeholder = (String)entry.getKey();
                String filePath = (String)entry.getValue();
                String jsContent = StaticCallGraphHtml.loadResourceContent(filePath);
                jsContent = StaticCallGraphHtml.processJsContent(jsContent);
                template = template.replace(placeholder, jsContent);
            }
            return template;
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating HTML with inlined resources", e);
        }
    }

    private static String processJsContent(String jsContent) {
        String processed = JS_FILE_IMPORT.matcher(D3_DAG_IMPORT.matcher(D3_IMPORT.matcher(jsContent).replaceAll("")).replaceAll("")).replaceAll("");
        processed = EXPORT_CONST.matcher(EXPORT_FUNC_CLASS.matcher(processed).replaceAll("$1 $2")).replaceAll("const $1 =");
        return processed;
    }

    private static String loadResourceContent(String resourcePath) throws IOException {
        InputStream inputStream = StaticCallGraphHtml.class.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            throw new IOException("Resource not found: " + resourcePath);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }
}

