/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.visualization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.flipkart.krystal.core.VajramID;
import com.flipkart.krystal.facets.InputMirror;
import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.traits.StaticDispatchPolicy;
import com.flipkart.krystal.traits.TraitDispatchPolicy;
import com.flipkart.krystal.vajram.ComputeVajramDef;
import com.flipkart.krystal.vajram.IOVajramDef;
import com.flipkart.krystal.vajram.VajramDefRoot;
import com.flipkart.krystal.vajram.exec.VajramDefinition;
import com.flipkart.krystal.vajram.facets.specs.DependencySpec;
import com.flipkart.krystal.vajram.facets.specs.FacetSpec;
import com.flipkart.krystal.vajramexecutor.krystex.VajramKryonGraph;
import com.flipkart.krystal.visualization.StaticCallGraphHtml;
import com.flipkart.krystal.visualization.models.Graph;
import com.flipkart.krystal.visualization.models.GraphGenerationResult;
import com.flipkart.krystal.visualization.models.Input;
import com.flipkart.krystal.visualization.models.Link;
import com.flipkart.krystal.visualization.models.Node;
import com.flipkart.krystal.visualization.models.VajramType;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticCallGraphGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaticCallGraphGenerator.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static GraphGenerationResult generateStaticCallGraphContent(VajramKryonGraph vajramKryonGraph, @Nullable String startVajram) {
        Graph fullGraph;
        Graph graphToVisualize = fullGraph = StaticCallGraphGenerator.createGraphData(vajramKryonGraph);
        if (startVajram != null && !startVajram.isBlank()) {
            Node startNode = fullGraph.nodes().stream().filter(node -> node.name().equals(startVajram)).findFirst().orElse(null);
            if (startNode != null) {
                graphToVisualize = StaticCallGraphGenerator.filterGraph(fullGraph, startNode.id());
            } else {
                throw new IllegalArgumentException("Start vajram: " + startVajram + " does not exist");
            }
        }
        String jsonGraph = StaticCallGraphGenerator.graphToJson(graphToVisualize);
        String htmlContent = StaticCallGraphHtml.generateStaticCallGraphHtml(jsonGraph);
        return GraphGenerationResult.builder().html(htmlContent).build();
    }

    private static Graph createGraphData(VajramKryonGraph vajramKryonGraph) {
        VajramDefinition definition;
        VajramID vajramId;
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Link> links = new ArrayList<Link>();
        ImmutableMap vajramDefinitions = vajramKryonGraph.vajramDefinitions();
        for (Map.Entry entry : vajramDefinitions.entrySet()) {
            vajramId = (VajramID)entry.getKey();
            definition = (VajramDefinition)entry.getValue();
            UnmodifiableIterator inputs = new ArrayList();
            for (InputMirror facet : definition.inputMirrors()) {
                String typeName;
                try {
                    typeName = facet.type().javaReflectType().getTypeName();
                }
                catch (ClassNotFoundException e) {
                    typeName = "<Unknown Type>";
                }
                inputs.add(Input.builder().name(facet.name()).type(typeName).isMandatory(facet.tags().getAnnotationByType(IfAbsent.class).map(mandatory -> mandatory.value().usePlatformDefault()).orElse(false) == false).documentation(facet.documentation()).build());
            }
            ImmutableCollection annotations = definition.vajramTags().annotations();
            List<String> annotationStringList = annotations.stream().map(Annotation::toString).toList();
            VajramType vajramType = StaticCallGraphGenerator.getVajramType(definition);
            if (vajramType == VajramType.UNKNOWN) {
                throw new IllegalArgumentException("Unknown vajram type for: " + String.valueOf(definition.def()));
            }
            Node node = Node.builder().id(vajramId.id()).name(definition.defType().getSimpleName()).vajramType(vajramType).inputs((List<Input>)inputs).annotationTags(annotationStringList).build();
            nodes.add(node);
        }
        for (Map.Entry entry : vajramDefinitions.entrySet()) {
            TraitDispatchPolicy traitDispatchPolicy;
            Link link;
            vajramId = (VajramID)entry.getKey();
            definition = (VajramDefinition)entry.getValue();
            for (FacetSpec facet : definition.facetSpecs()) {
                if (!(facet instanceof DependencySpec)) continue;
                DependencySpec dependencySpec = (DependencySpec)facet;
                VajramID dependencyId = dependencySpec.onVajramID();
                if (!vajramDefinitions.containsKey(vajramId) || !vajramDefinitions.containsKey(dependencyId)) continue;
                link = Link.builder().source(vajramId.id()).target(dependencyId.id()).name(facet.name()).isMandatory(facet.isMandatoryOnServer()).canFanout(facet.canFanout()).documentation(facet.documentation()).build();
                links.add(link);
            }
            if (!definition.isTrait() || (traitDispatchPolicy = vajramKryonGraph.getTraitDispatchPolicy(vajramId)) == null) continue;
            ImmutableSet conformingVajrams = traitDispatchPolicy.dispatchTargetIDs();
            for (VajramID conformant : conformingVajrams) {
                link = Link.builder().source(vajramId.id()).target(conformant.id()).name(traitDispatchPolicy instanceof StaticDispatchPolicy ? "<static dispatch>" : "<dynamic dispatch>").isMandatory(false).canFanout(false).documentation("Trait dispatch").build();
                links.add(link);
            }
        }
        return Graph.builder().nodes(nodes).links(links).build();
    }

    private static VajramType getVajramType(VajramDefinition vajramDef) {
        VajramDefRoot vajram = vajramDef.def();
        VajramType vajramType = vajram instanceof ComputeVajramDef ? VajramType.COMPUTE : (vajram instanceof IOVajramDef ? VajramType.IO : (vajramDef.isTrait() ? VajramType.COMPUTE : VajramType.UNKNOWN));
        return vajramType;
    }

    private static String graphToJson(Graph graph) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)graph);
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting graph data to JSON", e);
        }
    }

    private static Graph filterGraph(Graph fullGraph, String startNodeId) {
        HashMap adj = new HashMap();
        fullGraph.links().forEach(link -> adj.computeIfAbsent(link.source(), k -> new ArrayList()).add(link.target()));
        HashSet<String> reachable = new HashSet<String>();
        ArrayDeque<String> stack = new ArrayDeque<String>();
        stack.push(startNodeId);
        while (!stack.isEmpty()) {
            String current = (String)stack.pop();
            if (!reachable.add(current)) continue;
            List neighbors = adj.getOrDefault(current, List.of());
            neighbors.forEach(stack::push);
        }
        List<Node> filteredNodes = fullGraph.nodes().stream().filter(node -> reachable.contains(node.id())).toList();
        List<Link> filteredLinks = fullGraph.links().stream().filter(link -> reachable.contains(link.source()) && reachable.contains(link.target())).toList();
        return Graph.builder().nodes(filteredNodes).links(filteredLinks).build();
    }
}

