/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.pooling;

import com.flipkart.krystal.pooling.Lease;
import com.flipkart.krystal.pooling.LeaseUnavailableException;
import com.flipkart.krystal.pooling.MultiLeasePool;
import com.flipkart.krystal.pooling.MultiLeasePoolStats;
import com.flipkart.krystal.pooling.MultiLeasePoolStatsImpl;
import com.flipkart.krystal.pooling.PartitionedPool;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RandomMultiLeasePool<T>
implements MultiLeasePool<T> {
    private final PartitionedPool<T> pool;
    private final Consumer<T> destroyer;
    private final Random random = new Random();
    private final MultiLeasePoolStatsImpl.MultiLeasePoolStatsImplBuilder stats = MultiLeasePoolStatsImpl.builder();
    private final Supplier<@NonNull T> creator;
    private final int softMaxObjects;
    private boolean closed;

    public RandomMultiLeasePool(Supplier<@NonNull T> creator, int hardMaxLeasesPerObject, int softMaxObjects, Consumer<T> destroyer) {
        this.creator = creator;
        this.softMaxObjects = softMaxObjects;
        this.pool = new PartitionedPool(hardMaxLeasesPerObject);
        this.destroyer = destroyer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lease<T> lease() throws LeaseUnavailableException {
        if (this.closed) {
            throw new IllegalStateException("Pool has already been closed.");
        }
        PartitionedPool<T> partitionedPool = this.pool;
        synchronized (partitionedPool) {
            int availableCount = this.pool.availableCount();
            PartitionedPool.PooledObject<T> leasable = availableCount == 0 ? this.creatNewLeasable() : this.pool.getForLeasing(this.random.nextInt(availableCount));
            this.stats.reportNewLease(leasable.activeLeases());
            return new LeaseImpl<T>(leasable, toClose -> {
                PartitionedPool<T> partitionedPool = this.pool;
                synchronized (partitionedPool) {
                    this.pool.closeLease((PartitionedPool.PooledObject<T>)toClose);
                    if (this.closed && toClose.activeLeases() == 0) {
                        this.destroyer.accept(toClose.ref());
                    }
                }
                this.stats.reportLeaseClosed();
            });
        }
    }

    private PartitionedPool.PooledObject<T> creatNewLeasable() throws LeaseUnavailableException {
        if (this.pool.totalCount() >= this.softMaxObjects) {
            throw new LeaseUnavailableException("No more leases available");
        }
        PartitionedPool.PooledObject<T> toLease = this.pool.leaseAndAdd(this.creator.get());
        this.stats.reportNewObject();
        return toLease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.closed = true;
        if (this.pool.availableCount() > 0) {
            PartitionedPool<T> partitionedPool = this.pool;
            synchronized (partitionedPool) {
                if (this.pool.availableCount() > 0) {
                    PartitionedPool.PooledObject pooledObject;
                    UnmodifiableIterator<PartitionedPool.PooledObject<T>> unmodifiableIterator = this.pool.iterator();
                    while (unmodifiableIterator.hasNext() && (pooledObject = (PartitionedPool.PooledObject)unmodifiableIterator.next()).activeLeases() == 0) {
                        this.destroyer.accept(pooledObject.ref());
                    }
                }
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public MultiLeasePoolStats stats() {
        return this.stats.build();
    }

    private static class LeaseImpl<T>
    implements Lease<T> {
        private @Nullable PartitionedPool.PooledObject<T> pooledObject;
        private final Consumer<PartitionedPool.PooledObject<T>> closeLogic;

        private LeaseImpl(@NonNull PartitionedPool.PooledObject<T> pooledObject, Consumer<PartitionedPool.PooledObject<T>> closeLogic) {
            this.pooledObject = pooledObject;
            this.closeLogic = closeLogic;
        }

        @Override
        public @NonNull T get() {
            if (this.pooledObject == null) {
                throw new IllegalStateException("Lease already released");
            }
            return this.pooledObject.ref();
        }

        @Override
        public void close() {
            PartitionedPool.PooledObject<T> pooledObject = this.pooledObject;
            if (pooledObject != null) {
                this.closeLogic.accept(pooledObject);
                this.pooledObject = null;
            }
        }
    }
}

