/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.pooling;

import com.flipkart.krystal.pooling.MultiLeasePoolStats;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public record MultiLeasePoolStatsImpl(int currentPoolSize, int peakPoolSize, int peakLeasesOfAnObject, double peakAvgActiveLeasesPerObject, int currentActiveLeases) implements MultiLeasePoolStats
{
    @Generated
    public static @NonNull MultiLeasePoolStatsImplBuilder builder() {
        return new MultiLeasePoolStatsImplBuilder();
    }

    @Generated
    public @NonNull MultiLeasePoolStatsImplBuilder toBuilder() {
        return new MultiLeasePoolStatsImplBuilder().currentPoolSize(this.currentPoolSize).peakPoolSize(this.peakPoolSize).peakLeasesOfAnObject(this.peakLeasesOfAnObject).peakAvgActiveLeasesPerObject(this.peakAvgActiveLeasesPerObject).currentActiveLeases(this.currentActiveLeases);
    }

    public static class MultiLeasePoolStatsImplBuilder {
        @Generated
        private int currentPoolSize;
        @Generated
        private int peakPoolSize;
        @Generated
        private int peakLeasesOfAnObject;
        @Generated
        private double peakAvgActiveLeasesPerObject;
        @Generated
        private int currentActiveLeases;

        public void reportNewLease(int numberOfLeasesOfObject) {
            ++this.currentActiveLeases;
            this.peakLeasesOfAnObject = Math.max(this.peakLeasesOfAnObject, numberOfLeasesOfObject);
            this.peakAvgActiveLeasesPerObject = Math.max(this.peakAvgActiveLeasesPerObject, (double)this.currentActiveLeases * 1.0 / (double)this.currentPoolSize);
        }

        public void reportNewObject() {
            ++this.currentPoolSize;
            this.peakPoolSize = Math.max(this.peakPoolSize, this.currentPoolSize);
        }

        public void reportLeaseClosed() {
            --this.currentActiveLeases;
        }

        public void reportObjectDeleted() {
            --this.currentPoolSize;
        }

        public double getPeakAvgActiveLeasesPerObject() {
            return this.peakAvgActiveLeasesPerObject;
        }

        @Generated
        MultiLeasePoolStatsImplBuilder() {
        }

        @Generated
        public @NonNull MultiLeasePoolStatsImplBuilder currentPoolSize(int currentPoolSize) {
            this.currentPoolSize = currentPoolSize;
            return this;
        }

        @Generated
        public @NonNull MultiLeasePoolStatsImplBuilder peakPoolSize(int peakPoolSize) {
            this.peakPoolSize = peakPoolSize;
            return this;
        }

        @Generated
        public @NonNull MultiLeasePoolStatsImplBuilder peakLeasesOfAnObject(int peakLeasesOfAnObject) {
            this.peakLeasesOfAnObject = peakLeasesOfAnObject;
            return this;
        }

        @Generated
        public @NonNull MultiLeasePoolStatsImplBuilder peakAvgActiveLeasesPerObject(double peakAvgActiveLeasesPerObject) {
            this.peakAvgActiveLeasesPerObject = peakAvgActiveLeasesPerObject;
            return this;
        }

        @Generated
        public @NonNull MultiLeasePoolStatsImplBuilder currentActiveLeases(int currentActiveLeases) {
            this.currentActiveLeases = currentActiveLeases;
            return this;
        }

        @Generated
        public @NonNull MultiLeasePoolStatsImpl build() {
            return new MultiLeasePoolStatsImpl(this.currentPoolSize, this.peakPoolSize, this.peakLeasesOfAnObject, this.peakAvgActiveLeasesPerObject, this.currentActiveLeases);
        }

        @Generated
        public @NonNull String toString() {
            return "MultiLeasePoolStatsImpl.MultiLeasePoolStatsImplBuilder(currentPoolSize=" + this.currentPoolSize + ", peakPoolSize=" + this.peakPoolSize + ", peakLeasesOfAnObject=" + this.peakLeasesOfAnObject + ", peakAvgActiveLeasesPerObject=" + this.peakAvgActiveLeasesPerObject + ", currentActiveLeases=" + this.currentActiveLeases + ")";
        }
    }
}

