/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.datatypes;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.TypeUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JavaType<T>
implements DataType<T> {
    @lombok.NonNull
    private final String canonicalClassName;
    private final ImmutableList<DataType<?>> typeParameters;
    private final int numberOfArrayDimensions;
    private @MonotonicNonNull Type type;

    public static <T> JavaType<@NonNull T> create(Class<?> clazz, DataType<?> ... typeParams) {
        String canonicalClassName = clazz.getCanonicalName();
        if (canonicalClassName != null && TypeUtils.dataTypeMappings.containsKey(canonicalClassName)) {
            return TypeUtils.dataTypeMappings.get(canonicalClassName).apply(typeParams);
        }
        return new JavaType<T>(clazz, typeParams);
    }

    public static <T> JavaType<@NonNull T> create(String canonicalClassName, DataType<?> ... typeParameters) {
        if (TypeUtils.dataTypeMappings.containsKey(canonicalClassName)) {
            return TypeUtils.dataTypeMappings.get(canonicalClassName).apply(typeParameters);
        }
        return new JavaType<T>(canonicalClassName, typeParameters);
    }

    JavaType(Class<?> clazz, DataType<?> ... typeParameters) {
        this(Objects.requireNonNull(clazz.getCanonicalName()), clazz, typeParameters);
    }

    private JavaType(String canonicalClassName, DataType<?> ... typeParameters) {
        this(canonicalClassName, (Class<?>)null, typeParameters);
    }

    private JavaType(String canonicalClassName, @Nullable Class<?> clazz, DataType<?> ... typeParameters) {
        this.type = clazz;
        this.typeParameters = ImmutableList.copyOf((Object[])typeParameters);
        this.canonicalClassName = canonicalClassName;
        if (canonicalClassName.startsWith("@")) {
            throw new UnsupportedOperationException("Annotations not supported : " + canonicalClassName);
        }
        int dimensions = 0;
        if (canonicalClassName.endsWith("[]")) {
            String temp = canonicalClassName;
            while (temp.endsWith("[]")) {
                ++dimensions;
                temp = temp.substring(0, temp.length() - 2);
            }
        }
        this.numberOfArrayDimensions = dimensions;
    }

    @Override
    public Type javaReflectType() throws ClassNotFoundException {
        if (this.type == null) {
            Class<?> type = ((ClassLoader)Preconditions.checkNotNull((Object)this.getClass().getClassLoader())).loadClass(this.canonicalClassName());
            ArrayList<Type> list = new ArrayList<Type>();
            for (DataType typeParameter : this.typeParameters) {
                Type javaReflectType = typeParameter.javaReflectType();
                list.add(javaReflectType);
            }
            this.type = TypeUtils.getJavaType(type, list.toArray(new Type[0]));
        }
        return this.type;
    }

    public String toString() {
        return this.canonicalClassName() + (String)(this.typeParameters.isEmpty() ? "" : "< " + this.typeParameters.stream().map(Objects::toString).collect(Collectors.joining(", ")) + ">");
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaType)) {
            return false;
        }
        JavaType other = (JavaType)o;
        String this$canonicalClassName = this.canonicalClassName();
        String other$canonicalClassName = other.canonicalClassName();
        if (this$canonicalClassName == null ? other$canonicalClassName != null : !this$canonicalClassName.equals(other$canonicalClassName)) {
            return false;
        }
        ImmutableList<DataType<?>> this$typeParameters = this.typeParameters();
        ImmutableList<DataType<?>> other$typeParameters = other.typeParameters();
        return !(this$typeParameters == null ? other$typeParameters != null : !this$typeParameters.equals(other$typeParameters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $canonicalClassName = this.canonicalClassName();
        result = result * 59 + ($canonicalClassName == null ? 43 : $canonicalClassName.hashCode());
        ImmutableList<DataType<?>> $typeParameters = this.typeParameters();
        result = result * 59 + ($typeParameters == null ? 43 : $typeParameters.hashCode());
        return result;
    }

    @Override
    @lombok.NonNull
    @Generated
    public String canonicalClassName() {
        return this.canonicalClassName;
    }

    @Override
    @Generated
    public ImmutableList<DataType<?>> typeParameters() {
        return this.typeParameters;
    }

    @Generated
    public int numberOfArrayDimensions() {
        return this.numberOfArrayDimensions;
    }
}

