/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.except.StackTracelessException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Failure<T>
implements Errable<T> {
    private final Throwable error;
    private Optional<Throwable> o = Optional.empty();

    public Failure(Throwable error) {
        this.error = error;
    }

    @Override
    public CompletableFuture<@Nullable T> toFuture() {
        return CompletableFuture.failedFuture(this.error);
    }

    @Override
    public Optional<@NonNull T> valueOptOrThrow() {
        throw this.asRuntimException();
    }

    @Override
    public @NonNull T valueOrThrow() {
        throw this.asRuntimException();
    }

    @Override
    public Optional<@NonNull T> valueOpt() {
        return Optional.empty();
    }

    public String toString() {
        return this.error.toString();
    }

    public Throwable error() {
        return this.error;
    }

    @Override
    public Optional<Throwable> errorOpt() {
        return this.o.isPresent() ? this.o : (this.o = Optional.of(this.error));
    }

    private RuntimeException asRuntimException() {
        RuntimeException runtimeException;
        Throwable throwable = this.error;
        if (throwable instanceof RuntimeException) {
            RuntimeException e = (RuntimeException)throwable;
            runtimeException = e;
        } else {
            runtimeException = new StackTracelessException("Failure", this.error);
        }
        return runtimeException;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Failure)) {
            return false;
        }
        Failure other = (Failure)o;
        Throwable this$error = this.error();
        Throwable other$error = other.error();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Throwable $error = this.error();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }
}

