/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.concurrent;

import com.flipkart.krystal.except.StackTracelessCancellationException;
import com.flipkart.krystal.except.StackTracelessException;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.PolyNull;

public final class Futures {
    public static void propagateCancellation(CompletableFuture<?> from, CompletableFuture<?> to) {
        from.whenComplete((unused, throwable) -> {
            if (from.isDone() && !to.isDone()) {
                to.completeExceptionally(StackTracelessCancellationException.stackTracelessCancellation());
            }
        });
    }

    public static <T> void propagateCompletion(CompletableFuture<? extends @PolyNull T> from, CompletableFuture<@PolyNull T> to) {
        from.whenComplete((result, error) -> {
            if (error != null) {
                to.completeExceptionally(StackTracelessException.stackTracelessWrap(error));
            } else {
                to.complete(result);
            }
        });
    }

    public static <T> void linkFutures(CompletableFuture<? extends @PolyNull T> sourceFuture, CompletableFuture<@PolyNull T> destinationFuture) {
        Futures.propagateCompletion(sourceFuture, destinationFuture);
        Futures.propagateCancellation(destinationFuture, sourceFuture);
    }

    private Futures() {
    }
}

