/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.tags;

import com.flipkart.krystal.tags.AutoAnnotation_ElementTags_namedValueTag;
import com.flipkart.krystal.tags.NamedValueTag;
import com.google.auto.value.AutoAnnotation;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ElementTags {
    private static final ElementTags EMPTY_TAGS = new ElementTags(List.of());
    private final ImmutableMap<Class<? extends Annotation>, Annotation> annotationTags;
    private final ImmutableMap<String, NamedValueTag> namedValueTags;

    private ElementTags(Iterable<Annotation> tags) {
        ImmutableMap.Builder annos = ImmutableMap.builder();
        ImmutableMap.Builder namedValueTags = ImmutableMap.builder();
        for (Annotation annotation : tags) {
            if (annotation instanceof NamedValueTag) {
                NamedValueTag namedValueTag = (NamedValueTag)annotation;
                namedValueTags.put((Object)namedValueTag.name(), (Object)namedValueTag);
                continue;
            }
            annos.put(annotation.annotationType(), (Object)annotation);
        }
        this.annotationTags = annos.build();
        this.namedValueTags = namedValueTags.build();
    }

    private ElementTags(Map<Class<? extends Annotation>, Annotation> annotationTags, Map<String, NamedValueTag> namedValueTags) {
        this.annotationTags = ImmutableMap.copyOf(annotationTags);
        this.namedValueTags = ImmutableMap.copyOf(namedValueTags);
    }

    public static ElementTags of(Annotation ... tags) {
        return new ElementTags(Arrays.asList(tags));
    }

    public static ElementTags of(Collection<Annotation> tags) {
        if (tags.isEmpty()) {
            return ElementTags.emptyTags();
        }
        return new ElementTags(tags);
    }

    public static ElementTags emptyTags() {
        return EMPTY_TAGS;
    }

    public <A extends Annotation> Optional<A> getAnnotationByType(Class<? extends A> annotationType) {
        return Optional.ofNullable((Annotation)this.annotationTags.get(annotationType));
    }

    public Optional<NamedValueTag> getNamedValueTag(String name) {
        return Optional.ofNullable((NamedValueTag)this.namedValueTags.get((Object)name));
    }

    public ImmutableCollection<Annotation> annotations() {
        return this.annotationTags.values();
    }

    public ElementTags mergeAnnotations(Annotation ... annotations) {
        if (annotations.length == 0) {
            return this;
        }
        return this.mergeFrom(new ElementTags(Arrays.stream(annotations).toList()));
    }

    private ElementTags mergeFrom(ElementTags otherTags) {
        LinkedHashMap<Class<? extends Annotation>, Annotation> merged = new LinkedHashMap<Class<? extends Annotation>, Annotation>((Map<Class<? extends Annotation>, Annotation>)this.annotationTags);
        merged.putAll((Map<Class<? extends Annotation>, Annotation>)otherTags.annotationTags);
        LinkedHashMap<String, NamedValueTag> merged2 = new LinkedHashMap<String, NamedValueTag>((Map<String, NamedValueTag>)this.namedValueTags);
        merged2.putAll((Map<String, NamedValueTag>)otherTags.namedValueTags);
        return new ElementTags(merged, merged2);
    }

    @AutoAnnotation
    public static NamedValueTag namedValueTag(String name, String value) {
        return new AutoAnnotation_ElementTags_namedValueTag(name, value);
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementTags)) {
            return false;
        }
        ElementTags other = (ElementTags)o;
        ImmutableMap<Class<? extends Annotation>, Annotation> this$annotationTags = this.annotationTags;
        ImmutableMap<Class<? extends Annotation>, Annotation> other$annotationTags = other.annotationTags;
        if (this$annotationTags == null ? other$annotationTags != null : !this$annotationTags.equals(other$annotationTags)) {
            return false;
        }
        ImmutableMap<String, NamedValueTag> this$namedValueTags = this.namedValueTags;
        ImmutableMap<String, NamedValueTag> other$namedValueTags = other.namedValueTags;
        return !(this$namedValueTags == null ? other$namedValueTags != null : !this$namedValueTags.equals(other$namedValueTags));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableMap<Class<? extends Annotation>, Annotation> $annotationTags = this.annotationTags;
        result = result * 59 + ($annotationTags == null ? 43 : $annotationTags.hashCode());
        ImmutableMap<String, NamedValueTag> $namedValueTags = this.namedValueTags;
        result = result * 59 + ($namedValueTags == null ? 43 : $namedValueTags.hashCode());
        return result;
    }
}

