package com.flipkart.krystal.core;

import com.flipkart.krystal.data.FacetValues;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.Nullable;

/**
 * @param facetValues The facets to be used for executing the output logic
 * @param graphExecutor The executor service which is used to execute the krystal graph. Note that
 *     this might be an event loop executor, so no blocking operations are to performed in this.
 *     This useful, for example, in IOVajrams when a piece of logic (Output.unbatch, for example)
 *     needs to be executed in the same thread in which the executor service is running since it has
 *     the relevant logging context etc. configured.
 */
public record OutputLogicExecutionResults<T>(
    ImmutableMap<? extends FacetValues, CompletableFuture<@Nullable T>> results) {

  private static final OutputLogicExecutionResults<?> EMPTY =
      new OutputLogicExecutionResults<>(ImmutableMap.of());

  public OutputLogicExecutionResults<T> withResults(
      Map<? extends FacetValues, CompletableFuture<@Nullable T>> results) {
    return new OutputLogicExecutionResults<>(ImmutableMap.copyOf(results));
  }

  @SuppressWarnings("unchecked")
  public static <T> OutputLogicExecutionResults<T> empty() {
    return (OutputLogicExecutionResults<T>) EMPTY;
  }
}
