/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.facets;

import com.flipkart.krystal.data.IfNull;
import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.facets.BasicFacetInfo;
import com.flipkart.krystal.facets.Facet;
import com.flipkart.krystal.facets.FacetType;
import com.flipkart.krystal.tags.ElementTags;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public final class FacetUtils {
    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean isGiven(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Facet facet) {
        return facet.facetTypes().contains((Object)FacetType.INPUT) || facet.facetTypes().contains((Object)FacetType.INJECTION);
    }

    @SafeVarargs
    public static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Callable<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ElementTags> fieldTagsParser(Callable<Field> ... facetFieldSuppliers) {
        return () -> {
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            for (Callable facetFieldSupplier : facetFieldSuppliers) {
                annotationList.addAll(Arrays.asList(((Field)facetFieldSupplier.call()).getAnnotations()));
            }
            return ElementTags.of(annotationList);
        };
    }

    public static <T> @NonNull T computePlatformDefaultValue(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent BasicFacetInfo facetInfo, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataType<T> type) {
        Optional<IfNull> ifNull = facetInfo.tags().getAnnotationByType(IfNull.class);
        if (ifNull.isPresent()) {
            IfNull.IfNullThen ifNullThen = ifNull.get().value();
            if (!ifNullThen.usePlatformDefault()) {
                throw new UnsupportedOperationException("The @IfNull(...) facet '" + facetInfo.name() + "' is configured with strategy: " + ifNullThen + " which returns 'false' for usePlatformDefault(). Hence, platform default value is not supported. This method should not have been called. This seems to be krystal platform bug.");
            }
            try {
                return type.getPlatformDefaultValue();
            }
            catch (Throwable e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new AssertionError((Object)("@IfNull annotation missing on facet " + facetInfo.name() + ". This should not be possible as this method should not have been. Something is wrong in platform code!"));
    }

    @Generated
    private FacetUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

