/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.Failure;
import com.flipkart.krystal.data.Nil;
import com.flipkart.krystal.data.NonNil;
import com.flipkart.krystal.data.Success;
import com.flipkart.krystal.except.ThrowingCallable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Errable<@UnknownKeyFor T>
extends FacetValue<T>,
FacetValue.SingleFacetValue<T> {
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent CompletableFuture<@Nullable T> toFuture();

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<T> valueOpt();

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Throwable> errorOpt();

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<T> valueOptOrThrow();

    public T valueOrThrow();

    @Override
    default public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<T> singleValue() {
        return this;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<T> of(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<T> t) {
        return t;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<T> of(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<T> t) {
        return Errable.withValue(t.orElse(null));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<T> of(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object t) {
        if (t instanceof Errable) {
            if (t instanceof NonNil) {
                NonNil success = (NonNil)t;
                return Errable.of(success.value());
            }
            return (Errable)t;
        }
        if (t instanceof Optional) {
            Optional o = (Optional)t;
            return Errable.of(o.orElse(null));
        }
        return Errable.withValue(t);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<T> nil() {
        return Success.nil();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<T> withValue(@Nullable T t) {
        return t != null ? new NonNil<T>(t) : Errable.nil();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<T> withError(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Throwable t) {
        return new Failure(t);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<T> errableFrom(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ThrowingCallable<@Nullable T> valueProvider) {
        try {
            return Errable.withValue(valueProvider.call());
        }
        catch (Throwable e) {
            return Errable.withError(e);
        }
    }

    public static <S, T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Function<S, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<@NonNull T>> computeErrableFrom(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Function<S, @Nullable T> valueComputer) {
        return s -> Errable.errableFrom(() -> valueComputer.apply(s));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Errable<T> errableFrom(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object value, @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Throwable error) {
        if (value instanceof Optional) {
            Optional valueOpt = (Optional)value;
            if (valueOpt.isPresent()) {
                if (error != null) {
                    throw Errable.illegalState();
                }
                return Errable.errableFrom(valueOpt.get(), null);
            }
            if (error != null) {
                return Errable.withError(error);
            }
            return Nil.nil();
        }
        if (value != null) {
            if (error != null) {
                throw Errable.illegalState();
            }
            return Errable.withValue(value);
        }
        if (error != null) {
            return Errable.withError(error);
        }
        return Errable.nil();
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent IllegalArgumentException illegalState() {
        return new IllegalArgumentException("Both of 'value' and 'error' cannot be present together");
    }
}

