/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.datatypes;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.TypeUtils;
import com.google.common.base.Defaults;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.checker.optional.qual.Present;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.aliasing.qual.NonLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class JavaType<@UnknownKeyFor T>
implements DataType<T> {
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String canonicalClassName;
    private @MonotonicNonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String packageName;
    private @MonotonicNonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String simpleName;
    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> enclosingClasses = ImmutableList.of();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> typeParameters;
    private @MonotonicNonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Type clazz;

    JavaType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?> clazz, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> typeParams) {
        this(Optional.ofNullable(clazz.getPackage()).map(Package::getName), clazz.getSimpleName(), (List<String>)JavaType.getEnclosingClasses(clazz), (List<DataType<?>>)typeParams);
        this.clazz = clazz;
    }

    private JavaType(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> packageName, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String simpleName, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> enclosingClasses, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> typeParameters) {
        this(Stream.of(packageName.stream(), enclosingClasses.stream(), Stream.of(simpleName)).flatMap(Function.identity()).filter(Objects::nonNull).collect(Collectors.joining(".")), typeParameters);
        this.packageName = packageName.orElse(null);
        this.simpleName = simpleName;
        this.enclosingClasses = ImmutableList.copyOf(enclosingClasses);
    }

    private JavaType(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String canonicalClassName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> typeParameters) {
        this.canonicalClassName = canonicalClassName;
        this.typeParameters = ImmutableList.copyOf(typeParameters);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent JavaType<T> create(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<T> clazz) {
        return JavaType.create(clazz, ImmutableList.of());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent JavaType<T> create(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?> clazz, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> typeParams) {
        String canonicalClassName = clazz.getCanonicalName();
        if (canonicalClassName != null && TypeUtils.dataTypeMappings.containsKey(canonicalClassName)) {
            return TypeUtils.dataTypeMappings.get(canonicalClassName).apply(typeParams);
        }
        return new JavaType<T>(clazz, typeParams);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent JavaType<T> create(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String canonicalClassName, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent List<@KeyForBottom @NonNull @Initialized @UnknownThis @CalledMethodsBottom @MaybeLeaked @MaybeAliased @Present ? extends @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> typeParameters) {
        if (TypeUtils.dataTypeMappings.containsKey(canonicalClassName)) {
            return TypeUtils.dataTypeMappings.get(canonicalClassName).apply(typeParameters);
        }
        return new JavaType<T>(canonicalClassName, typeParameters);
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String canonicalClassName() {
        return this.canonicalClassName;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> packageName() {
        return Optional.ofNullable(this.packageName);
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Optional<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> simpleName() {
        return Optional.ofNullable(this.simpleName);
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> enclosingClasses() {
        return this.enclosingClasses;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Type javaReflectType() throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ClassNotFoundException {
        if (this.clazz == null) {
            if (!this.enclosingClasses.isEmpty()) {
                throw new UnsupportedOperationException("Cannot load java type of an enclosed class - only top level classes supported");
            }
            Class<?> type = ((ClassLoader)Preconditions.checkNotNull((Object)this.getClass().getClassLoader())).loadClass(this.canonicalClassName());
            ArrayList<Type> list = new ArrayList<Type>();
            for (DataType typeParameter : this.typeParameters) {
                Type javaReflectType = typeParameter.javaReflectType();
                list.add(javaReflectType);
            }
            this.clazz = TypeUtils.getJavaType(type, list.toArray(new Type[0]));
        }
        return this.clazz;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent TypeMirror javaModelType(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ProcessingEnvironment processingEnv) {
        TypeKind typeKind;
        if (this.clazz != null && (typeKind = TypeUtils.typeKindMappings.get(this.clazz)) != null && typeKind.isPrimitive()) {
            return processingEnv.getTypeUtils().getPrimitiveType(typeKind);
        }
        TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(this.canonicalClassName);
        if (typeElement == null) {
            throw new IllegalArgumentException("Could not find typeElement for canonical class name %s".formatted(this.canonicalClassName));
        }
        return processingEnv.getTypeUtils().getDeclaredType(typeElement, (TypeMirror[])this.typeParameters.stream().map(t -> TypeUtils.box(t.javaModelType(processingEnv), processingEnv)).toArray(TypeMirror[]::new));
    }

    @Override
    public T getPlatformDefaultValue() {
        try {
            Type type = this.javaReflectType();
            if (type instanceof Class) {
                Class c = (Class)type;
                Object defaultPrimitiveValue = Defaults.defaultValue((Class)c);
                if (defaultPrimitiveValue != null) {
                    return (T)defaultPrimitiveValue;
                }
                T defaultNonPrimitiveValue = this.defaultNonPrimitiveValue(c);
                if (defaultNonPrimitiveValue != null) {
                    return defaultNonPrimitiveValue;
                }
            } else {
                Class c;
                T defaultValue;
                ParameterizedType p;
                Type rawType;
                if (type instanceof ArrayType) {
                    return (T)new Object[0];
                }
                if (type instanceof ParameterizedType && (rawType = (p = (ParameterizedType)type).getRawType()) instanceof Class && (defaultValue = this.defaultNonPrimitiveValue(c = (Class)rawType)) != null) {
                    return defaultValue;
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException("Cannot determine platform default value for type %s".formatted(this));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean hasPlatformDefaultValue(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ProcessingEnvironment processingEnv) {
        return TypeUtils.hasPlatformDefaultValue(this.javaModelType(processingEnv));
    }

    private @Nullable T defaultNonPrimitiveValue(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?> c) {
        if (String.class.isAssignableFrom(c)) {
            return (T)"";
        }
        if (List.class.isAssignableFrom(c)) {
            return (T)List.of();
        }
        if (Map.class.isAssignableFrom(c)) {
            return (T)Map.of();
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String> getEnclosingClasses(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?> clazz) {
        ArrayDeque<String> enclosingClasses = new ArrayDeque<String>();
        Class<?> enclosingClass = clazz;
        while ((enclosingClass = enclosingClass.getEnclosingClass()) != null) {
            enclosingClasses.push(enclosingClass.getSimpleName());
        }
        return ImmutableList.copyOf(enclosingClasses);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent String toString() {
        try {
            return this.javaReflectType().toString();
        }
        catch (ClassNotFoundException e) {
            return super.toString();
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    @Generated
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent boolean equals(@Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaType)) {
            return false;
        }
        JavaType other = (JavaType)o;
        String this$canonicalClassName = this.canonicalClassName();
        String other$canonicalClassName = other.canonicalClassName();
        if (this$canonicalClassName == null ? other$canonicalClassName != null : !this$canonicalClassName.equals(other$canonicalClassName)) {
            return false;
        }
        ImmutableList<DataType<?>> this$typeParameters = this.typeParameters();
        ImmutableList<DataType<?>> other$typeParameters = other.typeParameters();
        return !(this$typeParameters == null ? other$typeParameters != null : !this$typeParameters.equals(other$typeParameters));
    }

    @Pure
    @Generated
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $canonicalClassName = this.canonicalClassName();
        result = result * 59 + ($canonicalClassName == null ? 43 : $canonicalClassName.hashCode());
        ImmutableList<DataType<?>> $typeParameters = this.typeParameters();
        result = result * 59 + ($typeParameters == null ? 43 : $typeParameters.hashCode());
        return result;
    }

    @Generated
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ImmutableList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @UnknownThis @UnknownThis @CalledMethods(value={}) @CalledMethodsBottom @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present ?>> typeParameters() {
        return this.typeParameters;
    }
}

