/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.pooling;

import com.flipkart.krystal.pooling.Lease;
import com.flipkart.krystal.pooling.LeaseUnavailableException;
import com.flipkart.krystal.pooling.MultiLeasePool;
import com.flipkart.krystal.pooling.MultiLeasePoolStats;
import com.flipkart.krystal.pooling.MultiLeasePoolStatsImpl;
import com.flipkart.krystal.pooling.PartitionedPool;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

public class RandomMultiLeasePool<@UnknownKeyFor T>
implements MultiLeasePool<T> {
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PartitionedPool<T> pool;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Consumer<T> destroyer;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Random random = new Random();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MultiLeasePoolStatsImpl.MultiLeasePoolStatsImplBuilder stats = MultiLeasePoolStatsImpl.builder();
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Supplier<@NonNull T> creator;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int softMaxObjects;
    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean closed;

    public RandomMultiLeasePool(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Supplier<@NonNull T> creator, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int hardMaxLeasesPerObject, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) int softMaxObjects, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Consumer<T> destroyer) {
        this.creator = creator;
        this.softMaxObjects = softMaxObjects;
        this.pool = new PartitionedPool(hardMaxLeasesPerObject);
        this.destroyer = destroyer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Lease<T> lease() throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) LeaseUnavailableException {
        if (this.closed) {
            throw new IllegalStateException("Pool has already been closed.");
        }
        PartitionedPool<T> partitionedPool = this.pool;
        synchronized (partitionedPool) {
            int availableCount = this.pool.availableCount();
            PartitionedPool.PooledObject<T> leasable = availableCount == 0 ? this.creatNewLeasable() : this.pool.getForLeasing(this.random.nextInt(availableCount));
            this.stats.reportNewLease(leasable.activeLeases());
            return new LeaseImpl<T>(leasable, toClose -> {
                PartitionedPool<T> partitionedPool = this.pool;
                synchronized (partitionedPool) {
                    this.pool.closeLease((PartitionedPool.PooledObject<T>)toClose);
                    if (this.closed && toClose.activeLeases() == 0) {
                        this.destroyer.accept(toClose.ref());
                    }
                }
                this.stats.reportLeaseClosed();
            });
        }
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PartitionedPool.PooledObject<T> creatNewLeasable() throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) LeaseUnavailableException {
        if (this.pool.totalCount() >= this.softMaxObjects) {
            throw new LeaseUnavailableException("No more leases available");
        }
        PartitionedPool.PooledObject<T> toLease = this.pool.leaseAndAdd(this.creator.get());
        this.stats.reportNewObject();
        return toLease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.closed = true;
        if (this.pool.availableCount() > 0) {
            PartitionedPool<T> partitionedPool = this.pool;
            synchronized (partitionedPool) {
                if (this.pool.availableCount() > 0) {
                    PartitionedPool.PooledObject pooledObject;
                    UnmodifiableIterator<PartitionedPool.PooledObject<T>> unmodifiableIterator = this.pool.iterator();
                    while (unmodifiableIterator.hasNext() && (pooledObject = (PartitionedPool.PooledObject)unmodifiableIterator.next()).activeLeases() == 0) {
                        this.destroyer.accept(pooledObject.ref());
                    }
                }
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) boolean isClosed() {
        return this.closed;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) MultiLeasePoolStats stats() {
        return this.stats.build();
    }

    private static class LeaseImpl<@UnknownKeyFor T>
    implements Lease<T> {
        private @Nullable @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) PartitionedPool.PooledObject<T> pooledObject;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Consumer<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PartitionedPool.PooledObject<T>> closeLogic;

        private LeaseImpl(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PartitionedPool.PooledObject<T> pooledObject, @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) Consumer<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) PartitionedPool.PooledObject<T>> closeLogic) {
            this.pooledObject = pooledObject;
            this.closeLogic = closeLogic;
        }

        @Override
        public T get() {
            if (this.pooledObject == null) {
                throw new IllegalStateException("Lease already released");
            }
            return this.pooledObject.ref();
        }

        @Override
        public void close() {
            PartitionedPool.PooledObject<T> pooledObject = this.pooledObject;
            if (pooledObject != null) {
                this.closeLogic.accept(pooledObject);
                this.pooledObject = null;
            }
        }
    }
}

