/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.FacetValue;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public record Errable<@UnknownKeyFor T>(@UnknownKeyFor @NonNull @Initialized Optional<T> value, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Throwable> error) implements FacetValue<T>
{
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Errable<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> EMPTY = new Errable(Optional.empty(), Optional.empty());

    public Errable(@UnknownKeyFor @NonNull @Initialized Optional<T> value, @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Throwable> error) {
        if (value.isPresent() && error.isPresent()) {
            throw new IllegalArgumentException("Both of 'value' and 'error' cannot be present together");
        }
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Errable<T> empty() {
        return EMPTY;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Errable<T> withValue(@Nullable T t) {
        return Errable.errableFrom(t, null);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Errable<T> withError(@UnknownKeyFor @NonNull @Initialized Throwable t) {
        return Errable.errableFrom(null, t);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Errable<T> errableFrom(@UnknownKeyFor @NonNull @Initialized Callable<@Nullable T> valueProvider) {
        try {
            return Errable.withValue(valueProvider.call());
        }
        catch (Throwable e) {
            return Errable.withError(e);
        }
    }

    public static <S, T> @UnknownKeyFor @NonNull @Initialized Function<S, @UnknownKeyFor @NonNull @Initialized Errable<T>> computeErrableFrom(@UnknownKeyFor @NonNull @Initialized Function<S, @Nullable T> valueComputer) {
        return s -> Errable.errableFrom(() -> valueComputer.apply(s));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Errable<T> errableFrom(@Nullable @UnknownKeyFor @Initialized Object value, @Nullable @UnknownKeyFor @Initialized Throwable error) {
        Optional o;
        return new Errable<T>(value instanceof Optional ? (o = (Optional)value) : Optional.ofNullable(value), Optional.ofNullable(error));
    }

    public @UnknownKeyFor @NonNull @Initialized CompletableFuture<@Nullable T> toFuture() {
        if (this.error().isPresent()) {
            return CompletableFuture.failedFuture(this.error().get());
        }
        return CompletableFuture.completedFuture(this.value().orElse(null));
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<T> getValueOrThrow() {
        Optional<Throwable> error = this.error();
        if (error.isPresent()) {
            Throwable throwable = error.get();
            if (throwable instanceof RuntimeException) {
                RuntimeException e = (RuntimeException)throwable;
                throw e;
            }
            throw new RuntimeException(error.get());
        }
        return this.value();
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        if (this.error.isPresent()) {
            return this.error.toString();
        }
        return String.valueOf(this.value().orElse(null));
    }
}

