/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.datatypes;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.TypeUtils;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class CustomType<@UnknownKeyFor T>
implements DataType<T> {
    private final @UnknownKeyFor @NonNull @Initialized String className;
    private @MonotonicNonNull @UnknownKeyFor @Initialized String packageName;
    private @MonotonicNonNull @UnknownKeyFor @Initialized String simpleName;
    private @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses = ImmutableList.of();
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters = ImmutableList.of();
    private @MonotonicNonNull @UnknownKeyFor @Initialized Type clazz;

    private CustomType(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        this(clazz.getPackageName(), clazz.getSimpleName(), CustomType.getEnclosingClasses(clazz));
        this.clazz = clazz;
    }

    public CustomType(@UnknownKeyFor @NonNull @Initialized String className) {
        this.className = className;
    }

    private CustomType(@UnknownKeyFor @NonNull @Initialized String className, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters) {
        this.className = className;
        this.typeParameters = ImmutableList.copyOf(typeParameters);
    }

    private CustomType(@UnknownKeyFor @NonNull @Initialized String packageName, @UnknownKeyFor @NonNull @Initialized String simpleName, @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses) {
        this(packageName, simpleName, (List<String>)enclosingClasses, new ArrayList());
    }

    private CustomType(@UnknownKeyFor @NonNull @Initialized String packageName, @UnknownKeyFor @NonNull @Initialized String simpleName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters) {
        this(Stream.of(Stream.of(packageName), enclosingClasses.stream(), Stream.of(simpleName)).flatMap(Function.identity()).collect(Collectors.joining(".")));
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.enclosingClasses = ImmutableList.copyOf(enclosingClasses);
        this.typeParameters = ImmutableList.copyOf(typeParameters);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CustomType<T> create(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
        return new CustomType<T>(clazz);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CustomType<T> create(@UnknownKeyFor @NonNull @Initialized String packageName, @UnknownKeyFor @NonNull @Initialized String simpleName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters) {
        return new CustomType<T>(packageName, simpleName, enclosingClasses, typeParameters);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CustomType<T> create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> typeInfo, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters) {
        if (typeInfo.isEmpty()) {
            throw new IllegalArgumentException("At least one type name is needed for java types.");
        }
        if (typeInfo.size() == 1) {
            return CustomType.create(typeInfo.get(0), typeParameters);
        }
        return CustomType.create(typeInfo.get(0), typeInfo.get(typeInfo.size() - 1), typeInfo.subList(1, typeInfo.size() - 1), typeParameters);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CustomType<T> create(@UnknownKeyFor @NonNull @Initialized String className, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters) {
        return new CustomType<T>(className, typeParameters);
    }

    public @UnknownKeyFor @NonNull @Initialized String className() {
        return this.className;
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> packageName() {
        return Optional.ofNullable(this.packageName);
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized String> simpleName() {
        return Optional.ofNullable(this.simpleName);
    }

    public @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> enclosingClasses() {
        return this.enclosingClasses;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Type> javaType() {
        if (this.clazz == null) {
            if (!this.enclosingClasses.isEmpty()) {
                throw new UnsupportedOperationException("Cannot load java type of an enclosed class - only top level classes supported");
            }
            try {
                Class<?> type = Optional.ofNullable(this.getClass().getClassLoader()).orElseThrow(() -> new IllegalStateException("null classloader returned. Cannot proceed further")).loadClass(this.className());
                List<Optional> types = this.typeParameters.stream().map(DataType::javaType).toList();
                if (!types.stream().allMatch(Optional::isPresent)) {
                    return Optional.empty();
                }
                this.clazz = TypeUtils.getJavaType(type, (Type[])types.stream().map(Optional::orElseThrow).toArray(Type[]::new));
            }
            catch (ClassNotFoundException e) {
                return Optional.empty();
            }
        }
        return Optional.of(this.clazz);
    }

    private static @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized String> getEnclosingClasses(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        ArrayDeque<String> enclosingClasses = new ArrayDeque<String>();
        Class<?> enclosingClass = clazz;
        while ((enclosingClass = enclosingClass.getEnclosingClass()) != null) {
            enclosingClasses.push(enclosingClass.getSimpleName());
        }
        return ImmutableList.copyOf(enclosingClasses);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "CustomType(className=" + this.className() + ", packageName=" + this.packageName() + ", simpleName=" + this.simpleName() + ", enclosingClasses=" + this.enclosingClasses() + ", typeParameters=" + this.typeParameters() + ", clazz=" + this.clazz + ")";
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized DataType<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeParameters() {
        return this.typeParameters;
    }
}

