/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.utils;

import com.flipkart.krystal.utils.DistributeLeases;
import com.flipkart.krystal.utils.MultiLeasePolicy;
import com.flipkart.krystal.utils.PreferObjectReuse;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MultiLeasePool<@UnknownKeyFor T>
implements AutoCloseable {
    private final @UnknownKeyFor @NonNull @Initialized Supplier<T> creator;
    private final @UnknownKeyFor @NonNull @Initialized MultiLeasePolicy leasePolicy;
    private final @UnknownKeyFor @NonNull @Initialized Consumer<T> destroyer;
    private volatile @UnknownKeyFor @NonNull @Initialized double peakAvgActiveLeasesPerObject;
    private volatile @UnknownKeyFor @NonNull @Initialized int maxPoolSize;
    private final @UnknownKeyFor @NonNull @Initialized Deque<@UnknownKeyFor @NonNull @Initialized PooledObject<T>> queue = new LinkedList<PooledObject<T>>();
    private volatile @UnknownKeyFor @NonNull @Initialized boolean closed;
    private volatile @UnknownKeyFor @NonNull @Initialized int maxActiveLeasesPerObject;

    public MultiLeasePool(@UnknownKeyFor @NonNull @Initialized Supplier<T> creator, @UnknownKeyFor @NonNull @Initialized MultiLeasePolicy leasePolicy, @UnknownKeyFor @NonNull @Initialized Consumer<T> destroyer) {
        this.creator = creator;
        this.leasePolicy = leasePolicy;
        this.destroyer = destroyer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final @UnknownKeyFor @NonNull @Initialized Lease<T> lease() {
        MultiLeasePool multiLeasePool = this;
        synchronized (multiLeasePool) {
            PooledObject<T> leasable;
            PooledObject<T> head;
            if (this.closed) {
                throw new IllegalStateException("MultiLeasePool already closed");
            }
            int count = this.queue.size();
            do {
                if ((head = this.queue.peek()) == null) continue;
                this.processNonNullHead();
            } while (head != null && --count > 0 && !this.canLeaseOut(head));
            if (head == null || !this.canLeaseOut(head)) {
                leasable = this.createNewForLeasing();
            } else {
                leasable = head;
                leasable.incrementActiveLeases();
            }
            this.maxActiveLeasesPerObject = Math.max(this.maxActiveLeasesPerObject, leasable.activeLeases());
            this.peakAvgActiveLeasesPerObject = Math.max(this.peakAvgActiveLeasesPerObject, this.queue.stream().mapToInt(PooledObject::activeLeases).average().orElse(0.0));
            return new Lease<T>(leasable, this::giveBack);
        }
    }

    private void processNonNullHead() {
        DistributeLeases distributeLeases;
        MultiLeasePolicy multiLeasePolicy;
        boolean shouldPushToLast;
        PooledObject<T> head = this.queue.poll();
        if (head == null) {
            return;
        }
        boolean bl = shouldPushToLast = !this.canLeaseOut(head) || (multiLeasePolicy = this.leasePolicy) instanceof DistributeLeases && (distributeLeases = (DistributeLeases)multiLeasePolicy).maxActiveObjects() == this.queue.size();
        if (shouldPushToLast && !this.shouldDelete(head)) {
            this.queue.add(head);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean shouldDelete(@Nullable @UnknownKeyFor @Initialized PooledObject<T> pooledObject) {
        if (pooledObject == null) {
            return false;
        }
        return pooledObject.markForDeletion > 100;
    }

    private void addLeasedToQueue(@UnknownKeyFor @NonNull @Initialized PooledObject<T> pooledObject) {
        if (this.leasePolicy instanceof PreferObjectReuse) {
            this.queue.addFirst(pooledObject);
        } else if (this.leasePolicy instanceof DistributeLeases) {
            this.queue.addLast(pooledObject);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean canLeaseOut(@UnknownKeyFor @NonNull @Initialized PooledObject<T> pooledObject) {
        if (this.shouldDelete(pooledObject)) {
            return false;
        }
        MultiLeasePolicy multiLeasePolicy = this.leasePolicy;
        if (multiLeasePolicy instanceof PreferObjectReuse) {
            PreferObjectReuse preferObjectReuse = (PreferObjectReuse)multiLeasePolicy;
            return pooledObject.activeLeases() < preferObjectReuse.maxActiveLeasesPerObject();
        }
        multiLeasePolicy = this.leasePolicy;
        if (multiLeasePolicy instanceof DistributeLeases) {
            DistributeLeases distributeLeases = (DistributeLeases)multiLeasePolicy;
            return pooledObject.activeLeases() < distributeLeases.distributionTriggerThreshold() || this.queue.size() == distributeLeases.maxActiveObjects();
        }
        throw new UnsupportedOperationException();
    }

    private synchronized void giveBack(@UnknownKeyFor @NonNull @Initialized PooledObject<T> pooledObject) {
        if (this.shouldDelete(pooledObject) && pooledObject.activeLeases() == 0) {
            this.destroyer.accept(pooledObject.ref());
        }
    }

    private @UnknownKeyFor @NonNull @Initialized PooledObject<T> createNewForLeasing() {
        PooledObject<T> pooledObject = new PooledObject<T>(this.creator.get(), this.maxActiveLeasesPerObject());
        pooledObject.incrementActiveLeases();
        this.addLeasedToQueue(pooledObject);
        this.maxPoolSize = Math.max(this.maxPoolSize, this.queue.size());
        return pooledObject;
    }

    public final @UnknownKeyFor @NonNull @Initialized int maxActiveLeasesPerObject() {
        return this.maxActiveLeasesPerObject;
    }

    public final @UnknownKeyFor @NonNull @Initialized double peakAvgActiveLeasesPerObject() {
        return this.peakAvgActiveLeasesPerObject;
    }

    public final @UnknownKeyFor @NonNull @Initialized int maxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void close() {
        PooledObject<T> pooledObject;
        this.closed = true;
        while ((pooledObject = this.queue.pollLast()) != null) {
            this.destroyer.accept(pooledObject.ref());
        }
    }

    private static final class PooledObject<@UnknownKeyFor T> {
        private final T ref;
        private final @UnknownKeyFor @NonNull @Initialized int deletionThreshold;
        private @UnknownKeyFor @NonNull @Initialized int activeLeases = 0;
        private @UnknownKeyFor @NonNull @Initialized int markForDeletion;

        private PooledObject(T ref, @UnknownKeyFor @NonNull @Initialized int deletionThreshold) {
            this.ref = ref;
            this.deletionThreshold = deletionThreshold;
        }

        private T ref() {
            return this.ref;
        }

        private @UnknownKeyFor @NonNull @Initialized int activeLeases() {
            return this.activeLeases;
        }

        private void incrementActiveLeases() {
            ++this.activeLeases;
            if (this.activeLeases() == this.deletionThreshold) {
                this.markForDeletion = 0;
            }
        }

        private void decrementActiveLeases() {
            --this.activeLeases;
            if (this.activeLeases() < this.deletionThreshold) {
                ++this.markForDeletion;
            }
        }
    }

    public static final class Lease<@UnknownKeyFor T>
    implements AutoCloseable {
        private @Nullable @UnknownKeyFor @Initialized PooledObject<T> pooledObject;
        private final @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized PooledObject<T>> giveback;

        private Lease(@NonNull @UnknownKeyFor @Initialized PooledObject<T> pooledObject, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized PooledObject<T>> giveback) {
            this.pooledObject = pooledObject;
            this.giveback = giveback;
        }

        public T get() {
            if (this.pooledObject == null) {
                throw new IllegalStateException("Lease already released");
            }
            return this.pooledObject.ref();
        }

        @Override
        public void close() {
            PooledObject<T> pooledObject = this.pooledObject;
            if (pooledObject != null) {
                this.giveback.accept(pooledObject);
                pooledObject.decrementActiveLeases();
                this.pooledObject = null;
            }
        }
    }
}

