/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public final class Inputs {
    private transient int $hashCodeCache;
    private final ImmutableMap<String, InputValue<Object>> values;
    private static final Inputs EMPTY = new Inputs((Map<String, InputValue<Object>>)ImmutableMap.of());

    public Inputs(Map<String, InputValue<Object>> values) {
        this.values = ImmutableMap.copyOf(values);
    }

    public <T> ValueOrError<T> getInputValue(String inputName) {
        InputValue inputValue = (InputValue)this.values.getOrDefault((Object)inputName, ValueOrError.empty());
        if (inputValue instanceof ValueOrError) {
            ValueOrError voe = (ValueOrError)inputValue;
            return voe;
        }
        throw new IllegalArgumentException("%s is not of type ValueOrError".formatted(inputName));
    }

    public <T> Optional<T> getInputValueOpt(String inputName) {
        return this.getInputValue(inputName).value();
    }

    public <T> T getInputValueOrThrow(String inputName) {
        return this.getInputValue(inputName).getValueOrThrow().orElseThrow();
    }

    public <T> T getInputValueOrDefault(String inputName, T defaultValue) {
        return this.getInputValueOpt(inputName).orElse(defaultValue);
    }

    public <T> Results<T> getDepValue(String inputName) {
        InputValue inputValue = (InputValue)this.values.getOrDefault((Object)inputName, Results.empty());
        if (inputValue instanceof Results) {
            Results voe = (Results)inputValue;
            return voe;
        }
        throw new IllegalArgumentException("%s is not of type Results".formatted(inputName));
    }

    public static Inputs union(Map<String, ? extends InputValue<Object>> inputs1, Map<String, ? extends InputValue<Object>> inputs2) {
        return new Inputs((Map<String, InputValue<Object>>)ImmutableMap.builderWithExpectedSize((int)(inputs1.size() + inputs2.size())).putAll(inputs1).putAll(inputs2).build());
    }

    public static Inputs empty() {
        return EMPTY;
    }

    public ImmutableMap<String, InputValue<Object>> values() {
        return this.values;
    }

    public String toString() {
        return this.values().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Inputs)) {
            return false;
        }
        Inputs other = (Inputs)o;
        ImmutableMap<String, InputValue<Object>> this$values = this.values;
        ImmutableMap<String, InputValue<Object>> other$values = other.values;
        return !(this$values == null ? other$values != null : !this$values.equals(other$values));
    }

    public int hashCode() {
        if (this.$hashCodeCache != 0) {
            return this.$hashCodeCache;
        }
        int PRIME = 59;
        int result = 1;
        ImmutableMap<String, InputValue<Object>> $values = this.values;
        if ((result = result * 59 + ($values == null ? 43 : $values.hashCode())) == 0) {
            result = Integer.MIN_VALUE;
        }
        this.$hashCodeCache = result;
        return result;
    }
}

