/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.datatypes;

import com.flipkart.krystal.datatypes.DataType;
import com.flipkart.krystal.datatypes.JavaDataType;
import com.flipkart.krystal.datatypes.TypeUtils;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class JavaType<T>
implements JavaDataType<T> {
    private final String className;
    private @MonotonicNonNull String packageName;
    private @MonotonicNonNull String simpleName;
    private ImmutableList<String> enclosingClasses = ImmutableList.of();
    private ImmutableList<DataType> typeParameters = ImmutableList.of();
    private @MonotonicNonNull Type clazz;

    private JavaType(Class<T> clazz) {
        this(clazz.getPackageName(), clazz.getSimpleName(), JavaType.getEnclosingClasses(clazz));
        this.clazz = clazz;
    }

    public JavaType(String className) {
        this.className = className;
    }

    private JavaType(String className, List<? extends DataType> typeParameters) {
        this.className = className;
        this.typeParameters = ImmutableList.copyOf(typeParameters);
    }

    public JavaType(String packageName, String simpleName, ImmutableList<String> enclosingClasses) {
        this(packageName, simpleName, (List<String>)enclosingClasses, new ArrayList());
    }

    public JavaType(String packageName, String simpleName, List<String> enclosingClasses, List<? extends DataType> typeParameters) {
        this(Stream.of(Stream.of(packageName), enclosingClasses.stream(), Stream.of(simpleName)).flatMap(Function.identity()).collect(Collectors.joining(".")));
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.enclosingClasses = ImmutableList.copyOf(enclosingClasses);
        this.typeParameters = ImmutableList.copyOf(typeParameters);
    }

    private static ImmutableList<String> getEnclosingClasses(Class<?> clazz) {
        ArrayDeque<String> enclosingClasses = new ArrayDeque<String>();
        Class<?> enclosingClass = clazz;
        while ((enclosingClass = enclosingClass.getEnclosingClass()) != null) {
            enclosingClasses.push(enclosingClass.getSimpleName());
        }
        return ImmutableList.copyOf(enclosingClasses);
    }

    public String className() {
        return this.className;
    }

    public Optional<String> packageName() {
        return Optional.ofNullable(this.packageName);
    }

    public Optional<String> simpleName() {
        return Optional.ofNullable(this.simpleName);
    }

    public ImmutableList<String> enclosingClasses() {
        return this.enclosingClasses;
    }

    @Override
    public Optional<Type> javaType() {
        block4: {
            if (this.clazz == null) {
                try {
                    Class<?> type;
                    this.clazz = type = this.getClass().getClassLoader().loadClass(this.className());
                    if (this.typeParameters.isEmpty()) break block4;
                    if (this.typeParameters.stream().map(TypeUtils::getJavaType).allMatch(Optional::isPresent)) {
                        this.clazz = new ParameterizedType(){

                            @Override
                            public Type[] getActualTypeArguments() {
                                return (Type[])JavaType.this.typeParameters.stream().map(TypeUtils::getJavaType).filter(Optional::isPresent).map(Optional::get).toArray(Type[]::new);
                            }

                            @Override
                            public Type getRawType() {
                                return type;
                            }

                            @Override
                            public Type getOwnerType() {
                                return null;
                            }
                        };
                        break block4;
                    }
                    return Optional.empty();
                }
                catch (ClassNotFoundException e) {
                    return Optional.empty();
                }
            }
        }
        return Optional.of(this.clazz);
    }

    public static <T> JavaType<T> java(Class<T> clazz) {
        return new JavaType<T>(clazz);
    }

    public static <T> JavaType<T> java(String packageName, String simpleName, List<String> enclosingClasses, List<? extends DataType> typeParameters) {
        return new JavaType<T>(packageName, simpleName, enclosingClasses, typeParameters);
    }

    public static <T> JavaType<T> java(List<String> typeInfo, List<? extends DataType> typeParameters) {
        if (typeInfo.size() < 1) {
            throw new IllegalArgumentException("At least one type name is needed for java types.");
        }
        if (typeInfo.size() == 1) {
            return JavaType.java(typeInfo.get(0), typeParameters);
        }
        return JavaType.java(typeInfo.get(0), typeInfo.get(typeInfo.size() - 1), typeInfo.subList(1, typeInfo.size() - 1), typeParameters);
    }

    public static <T> JavaType<T> java(String className) {
        return new JavaType<T>(className);
    }

    public static <T> JavaType<T> java(String className, List<? extends DataType> typeParameters) {
        return new JavaType<T>(className, typeParameters);
    }

    public ImmutableList<DataType> typeParameters() {
        return this.typeParameters;
    }
}

