/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.utils;

import com.flipkart.krystal.utils.DistributeLeases;
import com.flipkart.krystal.utils.MultiLeasePolicy;
import com.flipkart.krystal.utils.PreferObjectReuse;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MultiLeasePool<T>
implements AutoCloseable {
    private final Supplier<T> creator;
    private final MultiLeasePolicy leasePolicy;
    private final Consumer<T> destroyer;
    private volatile double peakAvgActiveLeasesPerObject;
    private volatile int maxPoolSize;
    private final Deque<PooledObject<T>> queue = new LinkedList<PooledObject<T>>();
    private volatile boolean closed;
    private volatile int maxActiveLeasesPerObject;

    public MultiLeasePool(Supplier<T> creator, MultiLeasePolicy leasePolicy, Consumer<T> destroyer) {
        this.creator = creator;
        this.leasePolicy = leasePolicy;
        this.destroyer = destroyer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Lease<T> lease() {
        MultiLeasePool multiLeasePool = this;
        synchronized (multiLeasePool) {
            PooledObject<T> leasable;
            PooledObject<T> head;
            if (this.closed) {
                throw new IllegalStateException("MultiLeasePool already closed");
            }
            int count = this.queue.size();
            do {
                if ((head = this.queue.peek()) == null) continue;
                this.processNonNullHead();
            } while (head != null && --count > 0 && !this.canLeaseOut(head));
            if (head == null || !this.canLeaseOut(head)) {
                leasable = this.createNewForLeasing();
            } else {
                leasable = head;
                leasable.incrementActiveLeases();
            }
            this.maxActiveLeasesPerObject = Math.max(this.maxActiveLeasesPerObject, leasable.activeLeases());
            this.peakAvgActiveLeasesPerObject = Math.max(this.peakAvgActiveLeasesPerObject, this.queue.stream().mapToInt(PooledObject::activeLeases).average().orElse(0.0));
            return new Lease<T>(leasable, this::giveBack);
        }
    }

    private void processNonNullHead() {
        DistributeLeases distributeLeases;
        MultiLeasePolicy multiLeasePolicy;
        boolean shouldPushToLast;
        PooledObject<T> head = this.queue.peek();
        boolean bl = shouldPushToLast = !this.canLeaseOut(head) || (multiLeasePolicy = this.leasePolicy) instanceof DistributeLeases && (distributeLeases = (DistributeLeases)multiLeasePolicy).maxActiveObjects() == this.queue.size();
        if (shouldPushToLast && !this.shouldDelete(head = this.queue.poll())) {
            this.queue.add(head);
        }
    }

    private boolean shouldDelete(@Nullable PooledObject<T> pooledObject) {
        if (pooledObject == null) {
            return false;
        }
        return pooledObject.markForDeletion > 100;
    }

    private void addLeasedToQueue(PooledObject<T> pooledObject) {
        if (this.leasePolicy instanceof PreferObjectReuse) {
            this.queue.addFirst(pooledObject);
        } else if (this.leasePolicy instanceof DistributeLeases) {
            this.queue.addLast(pooledObject);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private boolean canLeaseOut(PooledObject<T> pooledObject) {
        if (this.shouldDelete(pooledObject)) {
            return false;
        }
        MultiLeasePolicy multiLeasePolicy = this.leasePolicy;
        if (multiLeasePolicy instanceof PreferObjectReuse) {
            PreferObjectReuse preferObjectReuse = (PreferObjectReuse)multiLeasePolicy;
            return pooledObject.activeLeases() < preferObjectReuse.maxActiveLeasesPerObject();
        }
        multiLeasePolicy = this.leasePolicy;
        if (multiLeasePolicy instanceof DistributeLeases) {
            DistributeLeases distributeLeases = (DistributeLeases)multiLeasePolicy;
            return pooledObject.activeLeases() < distributeLeases.distributionTriggerThreshold() || this.queue.size() == distributeLeases.maxActiveObjects();
        }
        throw new UnsupportedOperationException();
    }

    private synchronized void giveBack(PooledObject<T> pooledObject) {
        if (this.shouldDelete(pooledObject) && pooledObject.activeLeases() == 0) {
            this.destroyer.accept(pooledObject.ref());
        }
    }

    private PooledObject<T> createNewForLeasing() {
        PooledObject<T> pooledObject = new PooledObject<T>(this.creator.get(), this.maxActiveLeasesPerObject());
        pooledObject.incrementActiveLeases();
        this.addLeasedToQueue(pooledObject);
        this.maxPoolSize = Math.max(this.maxPoolSize, this.queue.size());
        return pooledObject;
    }

    public final int maxActiveLeasesPerObject() {
        return this.maxActiveLeasesPerObject;
    }

    public final double peakAvgActiveLeasesPerObject() {
        return this.peakAvgActiveLeasesPerObject;
    }

    public final int maxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void close() {
        PooledObject<T> pooledObject;
        this.closed = true;
        while ((pooledObject = this.queue.pollLast()) != null) {
            this.destroyer.accept(pooledObject.ref());
        }
    }

    private static final class PooledObject<T> {
        private final T ref;
        private final int deletionThreshold;
        private int activeLeases = 0;
        private int markForDeletion;

        private PooledObject(T ref, int deletionThreshold) {
            this.ref = ref;
            this.deletionThreshold = deletionThreshold;
        }

        private T ref() {
            return this.ref;
        }

        private int activeLeases() {
            return this.activeLeases;
        }

        private void incrementActiveLeases() {
            ++this.activeLeases;
            if (this.activeLeases() == this.deletionThreshold) {
                this.markForDeletion = 0;
            }
        }

        private void decrementActiveLeases() {
            --this.activeLeases;
            if (this.activeLeases() < this.deletionThreshold) {
                ++this.markForDeletion;
            }
        }
    }

    public static final class Lease<T>
    implements AutoCloseable {
        private PooledObject<T> pooledObject;
        private final Consumer<PooledObject<T>> giveback;

        private Lease(PooledObject<T> pooledObject, Consumer<PooledObject<T>> giveback) {
            this.pooledObject = pooledObject;
            this.giveback = giveback;
        }

        public T get() {
            if (this.pooledObject == null) {
                throw new IllegalStateException("Lease already released");
            }
            return this.pooledObject.ref();
        }

        @Override
        public void close() {
            if (this.pooledObject != null) {
                this.giveback.accept(this.pooledObject);
                this.pooledObject.decrementActiveLeases();
                this.pooledObject = null;
            }
        }
    }
}

