/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.except;

import com.flipkart.krystal.except.StackTracingStrategy;
import java.util.Objects;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class KrystalExceptions {
    private static final ThreadLocal<@Nullable StackTracingStrategy> STACK_TRACING_STRATEGY = new ThreadLocal();
    private static final StackTracingStrategy DEFAULT_STACK_TRACING_STRATEGY = KrystalExceptions.stackTracingSystemProperty();

    public static @Nullable StackTracingStrategy setStackTracingStrategyForCurrentThread(@Nullable StackTracingStrategy stackTracingStrategy) {
        StackTracingStrategy oldValue = STACK_TRACING_STRATEGY.get();
        STACK_TRACING_STRATEGY.set(stackTracingStrategy);
        return oldValue;
    }

    static StackTracingStrategy getStackTracingStrategyForCurrentThread() {
        return Objects.requireNonNullElse(STACK_TRACING_STRATEGY.get(), DEFAULT_STACK_TRACING_STRATEGY);
    }

    private static StackTracingStrategy stackTracingSystemProperty() {
        try {
            return StackTracingStrategy.valueOf(System.getProperty("KrystalException.defaultStackTracingStrategy", StackTracingStrategy.DONT_FILL.name()));
        }
        catch (IllegalArgumentException e) {
            return StackTracingStrategy.DEFAULT;
        }
    }

    @Generated
    private KrystalExceptions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

