/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.except;

import com.flipkart.krystal.except.KrystalExceptions;
import com.flipkart.krystal.except.StackTracingStrategy;
import java.util.concurrent.CompletionException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KrystalCompletionException
extends CompletionException {
    protected KrystalCompletionException() {
        this((String)null);
    }

    public KrystalCompletionException(@Nullable String message) {
        this(message, null);
    }

    public KrystalCompletionException(@Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    @Override
    public final Throwable fillInStackTrace() {
        return switch (KrystalExceptions.getStackTracingStrategyForCurrentThread()) {
            default -> throw new IncompatibleClassChangeError();
            case StackTracingStrategy.FILL -> super.fillInStackTrace();
            case StackTracingStrategy.DEFAULT, StackTracingStrategy.DONT_FILL -> this;
        };
    }

    public static CompletionException wrapAsCompletionException(Throwable t) {
        if (t instanceof CompletionException) {
            CompletionException c = (CompletionException)t;
            return c;
        }
        String message = t.getMessage();
        return new KrystalCompletionException(message != null ? message : t.getClass().getName(), t);
    }
}

