/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.datatypes;

import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Trilean {
    UNKNOWN{

        @Override
        public Trilean or(Trilean other) {
            return switch (other) {
                default -> throw new IncompatibleClassChangeError();
                case TRUE -> TRUE;
                case UNKNOWN, FALSE -> UNKNOWN;
            };
        }

        @Override
        public Trilean and(Trilean other) {
            return switch (other) {
                default -> throw new IncompatibleClassChangeError();
                case TRUE, UNKNOWN -> UNKNOWN;
                case FALSE -> FALSE;
            };
        }

        @Override
        public Trilean negation() {
            return UNKNOWN;
        }

        public String toString() {
            return "unknown";
        }
    }
    ,
    TRUE{

        @Override
        public Trilean or(Trilean other) {
            return TRUE;
        }

        @Override
        public Trilean and(Trilean other) {
            return other;
        }

        @Override
        public Trilean negation() {
            return FALSE;
        }

        public String toString() {
            return "true";
        }
    }
    ,
    FALSE{

        @Override
        public Trilean or(Trilean other) {
            return other;
        }

        @Override
        public Trilean and(Trilean other) {
            return FALSE;
        }

        @Override
        public Trilean negation() {
            return TRUE;
        }

        public String toString() {
            return "false";
        }
    };


    public static Trilean toTrilean(boolean bool) {
        if (bool) {
            return TRUE;
        }
        return FALSE;
    }

    public static Trilean toTrilean(@Nullable Boolean b) {
        if (b == null) {
            return UNKNOWN;
        }
        return Trilean.toTrilean((boolean)b);
    }

    public abstract Trilean or(Trilean var1);

    public Trilean or(boolean other) {
        return this.or(Trilean.toTrilean(other));
    }

    public abstract Trilean and(Trilean var1);

    public Trilean and(boolean other) {
        return this.and(Trilean.toTrilean(other));
    }

    public abstract Trilean negation();

    public static Trilean not(Trilean t) {
        return t.negation();
    }

    public static Trilean orOf(Trilean ... trileans) {
        Trilean value = FALSE;
        for (Trilean t : trileans) {
            if (value == TRUE) {
                return value;
            }
            value = value.or(t);
        }
        return value;
    }

    public static Trilean andOf(Trilean ... trileans) {
        Trilean value = TRUE;
        for (Trilean t : trileans) {
            if (value == FALSE) {
                return value;
            }
            value = value.or(t);
        }
        return value;
    }
}

