/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.concurrent;

import com.flipkart.krystal.except.KrystalCancellationException;
import com.flipkart.krystal.except.KrystalCompletionException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

public final class Futures {
    public static void propagateCancellation(CompletableFuture<?> from, CompletableFuture<?> to) {
        Futures.propagateCancellation(from, to, null);
    }

    public static void propagateCancellation(CompletableFuture<?> from, CompletableFuture<?> to, @Nullable ExecutorService executorService) {
        BiConsumer<@Nullable Object, Throwable> action = (unused, throwable) -> {
            if (from.isDone() && !to.isDone()) {
                to.completeExceptionally(new KrystalCancellationException());
            }
        };
        if (executorService == null) {
            from.whenComplete((BiConsumer)action);
        } else {
            from.whenCompleteAsync((BiConsumer)action, (Executor)executorService);
        }
    }

    public static <T> void propagateCompletion(CompletableFuture<? extends @PolyNull T> from, CompletableFuture<@PolyNull T> to) {
        Futures.propagateCompletion(from, to, null);
    }

    public static <T> void propagateCompletion(CompletableFuture<? extends @PolyNull T> from, CompletableFuture<@PolyNull T> to, @Nullable ExecutorService executorService) {
        BiConsumer<@PolyNull Object, Throwable> action = (result, error) -> {
            if (error != null) {
                to.completeExceptionally(KrystalCompletionException.wrapAsCompletionException(error));
            } else {
                to.complete(result);
            }
        };
        if (executorService == null) {
            from.whenComplete(action);
        } else {
            from.whenCompleteAsync(action, (Executor)executorService);
        }
    }

    public static <T> void linkFutures(CompletableFuture<? extends @PolyNull T> sourceFuture, CompletableFuture<@PolyNull T> destinationFuture) {
        Futures.linkFutures(sourceFuture, destinationFuture, null);
    }

    public static <T> void linkFutures(CompletableFuture<? extends @PolyNull T> sourceFuture, CompletableFuture<@PolyNull T> destinationFuture, @Nullable ExecutorService executorService) {
        Futures.propagateCompletion(sourceFuture, destinationFuture, executorService);
        Futures.propagateCancellation(destinationFuture, sourceFuture, executorService);
    }

    private Futures() {
    }
}

