/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.FacetValue;
import com.flipkart.krystal.data.Failure;
import com.flipkart.krystal.data.Nil;
import com.flipkart.krystal.data.NonNil;
import com.flipkart.krystal.data.Success;
import com.flipkart.krystal.except.ThrowingCallable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Errable<T>
extends FacetValue<T>,
FacetValue.SingleFacetValue<T> {
    public CompletableFuture<@Nullable T> toFuture();

    public @Nullable T value();

    public Optional<T> valueOpt();

    public Optional<Throwable> errorOpt();

    public Optional<T> valueOptOrThrow();

    public T valueOrThrow();

    @Override
    default public Errable<T> asErrable() {
        return this;
    }

    public static <T> Errable<T> nil() {
        return Success.nil();
    }

    public static <T> Errable<T> withValue(@Nullable T t) {
        return t != null ? new NonNil<T>(t) : Errable.nil();
    }

    public static <T> Errable<T> withError(Throwable t) {
        return new Failure(t);
    }

    public static <T> Errable<T> errableFrom(ThrowingCallable<@Nullable T> valueProvider) {
        try {
            return Errable.withValue(valueProvider.call());
        }
        catch (Throwable e) {
            return Errable.withError(e);
        }
    }

    public static <S, T> Function<S, Errable<@NonNull T>> computeErrableFrom(Function<S, @Nullable T> valueComputer) {
        return s -> Errable.errableFrom(() -> valueComputer.apply(s));
    }

    public static <T> Errable<T> errableFrom(@Nullable Object value, @Nullable Throwable error) {
        if (value instanceof Optional) {
            Optional valueOpt = (Optional)value;
            if (valueOpt.isPresent()) {
                if (error != null) {
                    throw Errable.illegalState();
                }
                return Errable.errableFrom(valueOpt.get(), null);
            }
            if (error != null) {
                return Errable.withError(error);
            }
            return Nil.nil();
        }
        if (value != null) {
            if (error != null) {
                throw Errable.illegalState();
            }
            return Errable.withValue(value);
        }
        if (error != null) {
            return Errable.withError(error);
        }
        return Errable.nil();
    }

    private static IllegalArgumentException illegalState() {
        return new IllegalArgumentException("Both of 'value' and 'error' cannot be present together");
    }
}

