/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.facets.resolution;

import com.flipkart.krystal.data.ImmutableRequest;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface ResolverCommand {
    public List<? extends ImmutableRequest.Builder<?>> getRequests();

    public static SkipDependency skip(String reason) {
        return ResolverCommand.skip(reason, null);
    }

    public static SkipDependency skip(String reason, @Nullable Throwable skipCause) {
        return new SkipDependency(reason, skipCause);
    }

    public static ExecuteDependency executeWithRequests(List<? extends  @NonNull ImmutableRequest.Builder<?>> inputs) {
        return new ExecuteDependency(inputs);
    }

    public record SkipDependency(String reason, @Nullable Throwable cause) implements ResolverCommand
    {
        public ImmutableList<? extends ImmutableRequest.Builder<?>> getRequests() {
            return ImmutableList.of();
        }
    }

    public record ExecuteDependency(List<? extends ImmutableRequest.Builder<?>> requests) implements ResolverCommand
    {
        @Override
        public List<? extends ImmutableRequest.Builder<?>> getRequests() {
            return this.requests;
        }
    }
}

