/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.datatypes;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Trilean {
    UNKNOWN{

        @Override
        public Trilean or(Trilean other) {
            return switch (other) {
                default -> throw new IncompatibleClassChangeError();
                case TRUE -> TRUE;
                case UNKNOWN, FALSE -> UNKNOWN;
            };
        }

        @Override
        public Trilean and(Trilean other) {
            return switch (other) {
                default -> throw new IncompatibleClassChangeError();
                case TRUE, UNKNOWN -> UNKNOWN;
                case FALSE -> FALSE;
            };
        }
    }
    ,
    TRUE{

        @Override
        public Trilean or(Trilean other) {
            return TRUE;
        }

        @Override
        public Trilean and(Trilean other) {
            return other;
        }
    }
    ,
    FALSE{

        @Override
        public Trilean or(Trilean other) {
            return other;
        }

        @Override
        public Trilean and(Trilean other) {
            return FALSE;
        }
    };


    public static Trilean toTrilean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public abstract Trilean or(Trilean var1);

    public Trilean or(boolean other) {
        return this.or(Trilean.toTrilean(other));
    }

    public abstract Trilean and(Trilean var1);

    public Trilean and(boolean other) {
        return this.and(Trilean.toTrilean(other));
    }

    public static Trilean not(Trilean t) {
        return switch (t) {
            default -> throw new IncompatibleClassChangeError();
            case UNKNOWN -> UNKNOWN;
            case TRUE -> FALSE;
            case FALSE -> TRUE;
        };
    }

    public static Trilean orOf(Trilean ... trileans) {
        Trilean value = FALSE;
        for (Trilean t : trileans) {
            if (value == TRUE) {
                return value;
            }
            value = value.or(t);
        }
        return value;
    }

    public static Trilean andOf(Trilean ... trileans) {
        Trilean value = TRUE;
        for (Trilean t : trileans) {
            if (value == FALSE) {
                return value;
            }
            value = value.or(t);
        }
        return value;
    }
}

