/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.pooling;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import lombok.Generated;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.optional.qual.MaybePresent;
import org.checkerframework.common.aliasing.qual.MaybeAliased;
import org.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;

class PartitionedPool<@UnknownKeyFor T>
implements Iterable<PooledObject<T>> {
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int hardMaxLeasesPerObject;
    private final @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent ArrayList<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent PooledObject<T>> partitionedList = new ArrayList();
    private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int unavailableStartIndex = 0;

    PartitionedPool(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int hardMaxLeasesPerObject) {
        this.hardMaxLeasesPerObject = hardMaxLeasesPerObject;
    }

    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int availableCount() {
        return this.unavailableStartIndex;
    }

    public @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int totalCount() {
        return this.partitionedList.size();
    }

    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent PooledObject<T> getForLeasing(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int i) throws @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent IllegalArgumentException {
        if (i >= this.unavailableStartIndex || i < 0) {
            throw new IllegalArgumentException("Index [" + i + "] is not available for leasing");
        }
        PooledObject<T> toLease = this.partitionedList.get(i);
        toLease.incrementActiveLeases();
        if (toLease.activeLeases() >= this.hardMaxLeasesPerObject) {
            this.tryMakeUnavailable(toLease.index());
        }
        return toLease;
    }

    void closeLease(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent PooledObject<T> toClose) {
        toClose.decrementActiveLeases();
        this.tryMakeAvailable(toClose.index());
    }

    @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent PooledObject<T> leaseAndAdd(@NonNull T toLease) {
        PooledObject<T> pooledObject = new PooledObject<T>(toLease);
        pooledObject.index(this.partitionedList.size());
        this.partitionedList.add(pooledObject);
        pooledObject.incrementActiveLeases();
        this.tryMakeAvailable(pooledObject.index());
        return pooledObject;
    }

    private void tryMakeAvailable(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int indexToMakeAvailable) {
        int unavailableStartIndex = this.unavailableStartIndex;
        Preconditions.checkArgument((indexToMakeAvailable < this.partitionedList.size() ? 1 : 0) != 0, (Object)"Index to make unavailable should be < elements.size()");
        if (indexToMakeAvailable < unavailableStartIndex) {
            return;
        }
        if (this.partitionedList.get((int)indexToMakeAvailable).activeLeases >= this.hardMaxLeasesPerObject) {
            return;
        }
        PooledObject<T> toMove = this.partitionedList.get(indexToMakeAvailable);
        PooledObject<T> other = this.partitionedList.get(unavailableStartIndex);
        toMove.index(unavailableStartIndex);
        other.index(indexToMakeAvailable);
        this.partitionedList.set(other.index(), other);
        this.partitionedList.set(toMove.index(), toMove);
        ++this.unavailableStartIndex;
    }

    private void tryMakeUnavailable(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int indexToMakeUnavailable) {
        Preconditions.checkArgument((indexToMakeUnavailable >= 0 ? 1 : 0) != 0, (Object)"Index to make unavailable should be >= 0");
        Preconditions.checkArgument((indexToMakeUnavailable < this.partitionedList.size() ? 1 : 0) != 0, (Object)"Index to make unavailable should be < elements.size()");
        if (indexToMakeUnavailable >= this.unavailableStartIndex) {
            return;
        }
        int newUnavailableStartIndex = this.unavailableStartIndex - 1;
        if (this.partitionedList.get((int)indexToMakeUnavailable).activeLeases < this.hardMaxLeasesPerObject) {
            return;
        }
        PooledObject<T> toMove = this.partitionedList.get(indexToMakeUnavailable);
        PooledObject<T> other = this.partitionedList.get(newUnavailableStartIndex);
        other.index(indexToMakeUnavailable);
        toMove.index(newUnavailableStartIndex);
        this.partitionedList.set(other.index(), other);
        this.partitionedList.set(toMove.index(), toMove);
        --this.unavailableStartIndex;
    }

    @Override
    public @NonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent UnmodifiableIterator<@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent PooledObject<T>> iterator() {
        return ImmutableList.copyOf(this.partitionedList).iterator();
    }

    static final class PooledObject<@UnknownKeyFor T> {
        private final @NonNull T ref;
        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int index;
        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int activeLeases = 0;

        void incrementActiveLeases() {
            ++this.activeLeases;
        }

        void decrementActiveLeases() {
            --this.activeLeases;
        }

        @Generated
        private @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int index() {
            return this.index;
        }

        @Generated
        private PooledObject(@NonNull T ref) {
            if (ref == null) {
                throw new NullPointerException("ref is marked non-null but is null");
            }
            this.ref = ref;
        }

        @Generated
        @NonNull T ref() {
            return this.ref;
        }

        @Generated
        private @NonNull @UnknownKeyFor @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent PooledObject<T> index(@UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int index) {
            this.index = index;
            return this;
        }

        @Generated
        @UnknownKeyFor @NonNull @Initialized @UnknownThis @CalledMethods(value={}) @MaybeLeaked @MaybeAliased @MaybePresent int activeLeases() {
            return this.activeLeases;
        }
    }
}

