/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.pooling;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

class PartitionedPool<T>
implements Iterable<PooledObject<T>> {
    private final int hardMaxLeasesPerObject;
    private final ArrayList<PooledObject<T>> partitionedList = new ArrayList();
    private int unavailableStartIndex = 0;

    PartitionedPool(int hardMaxLeasesPerObject) {
        this.hardMaxLeasesPerObject = hardMaxLeasesPerObject;
    }

    int availableCount() {
        return this.unavailableStartIndex;
    }

    public int totalCount() {
        return this.partitionedList.size();
    }

    PooledObject<T> getForLeasing(int i) throws IllegalArgumentException {
        if (i >= this.unavailableStartIndex || i < 0) {
            throw new IllegalArgumentException("Index [" + i + "] is not available for leasing");
        }
        PooledObject<T> toLease = this.partitionedList.get(i);
        toLease.incrementActiveLeases();
        if (toLease.activeLeases() >= this.hardMaxLeasesPerObject) {
            this.tryMakeUnavailable(toLease.index());
        }
        return toLease;
    }

    void closeLease(PooledObject<T> toClose) {
        toClose.decrementActiveLeases();
        this.tryMakeAvailable(toClose.index());
    }

    PooledObject<T> leaseAndAdd(@NonNull T toLease) {
        PooledObject<T> pooledObject = new PooledObject<T>(toLease);
        pooledObject.index(this.partitionedList.size());
        this.partitionedList.add(pooledObject);
        pooledObject.incrementActiveLeases();
        this.tryMakeAvailable(pooledObject.index());
        return pooledObject;
    }

    private void tryMakeAvailable(int indexToMakeAvailable) {
        int unavailableStartIndex = this.unavailableStartIndex;
        Preconditions.checkArgument((indexToMakeAvailable < this.partitionedList.size() ? 1 : 0) != 0, (Object)"Index to make unavailable should be < elements.size()");
        if (indexToMakeAvailable < unavailableStartIndex) {
            return;
        }
        if (this.partitionedList.get((int)indexToMakeAvailable).activeLeases >= this.hardMaxLeasesPerObject) {
            return;
        }
        PooledObject<T> toMove = this.partitionedList.get(indexToMakeAvailable);
        PooledObject<T> other = this.partitionedList.get(unavailableStartIndex);
        toMove.index(unavailableStartIndex);
        other.index(indexToMakeAvailable);
        this.partitionedList.set(other.index(), other);
        this.partitionedList.set(toMove.index(), toMove);
        ++this.unavailableStartIndex;
    }

    private void tryMakeUnavailable(int indexToMakeUnavailable) {
        Preconditions.checkArgument((indexToMakeUnavailable >= 0 ? 1 : 0) != 0, (Object)"Index to make unavailable should be >= 0");
        Preconditions.checkArgument((indexToMakeUnavailable < this.partitionedList.size() ? 1 : 0) != 0, (Object)"Index to make unavailable should be < elements.size()");
        if (indexToMakeUnavailable >= this.unavailableStartIndex) {
            return;
        }
        int newUnavailableStartIndex = this.unavailableStartIndex - 1;
        if (this.partitionedList.get((int)indexToMakeUnavailable).activeLeases < this.hardMaxLeasesPerObject) {
            return;
        }
        PooledObject<T> toMove = this.partitionedList.get(indexToMakeUnavailable);
        PooledObject<T> other = this.partitionedList.get(newUnavailableStartIndex);
        other.index(indexToMakeUnavailable);
        toMove.index(newUnavailableStartIndex);
        this.partitionedList.set(other.index(), other);
        this.partitionedList.set(toMove.index(), toMove);
        --this.unavailableStartIndex;
    }

    @Override
    public @NonNull UnmodifiableIterator<PooledObject<T>> iterator() {
        return ImmutableList.copyOf(this.partitionedList).iterator();
    }

    static final class PooledObject<T> {
        private final @NonNull T ref;
        private int index;
        private int activeLeases = 0;

        void incrementActiveLeases() {
            ++this.activeLeases;
        }

        void decrementActiveLeases() {
            --this.activeLeases;
        }

        @Generated
        private int index() {
            return this.index;
        }

        @Generated
        private PooledObject(@NonNull T ref) {
            if (ref == null) {
                throw new NullPointerException("ref is marked non-null but is null");
            }
            this.ref = ref;
        }

        @Generated
        @NonNull T ref() {
            return this.ref;
        }

        @Generated
        private @NonNull PooledObject<T> index(int index) {
            this.index = index;
            return this;
        }

        @Generated
        int activeLeases() {
            return this.activeLeases;
        }
    }
}

