/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.core;

import com.flipkart.krystal.data.ExecutionItem;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class OutputLogicExecutionInput {
    private final List<ExecutionItem> facetValueResponses;
    private final ExecutorService graphExecutor;
    private CompletableFuture @MonotonicNonNull [] responseFutures;

    public OutputLogicExecutionInput(List<ExecutionItem> facetValueResponses, ExecutorService graphExecutor) {
        facetValueResponses = Collections.unmodifiableList(facetValueResponses);
        this.facetValueResponses = facetValueResponses;
        this.graphExecutor = graphExecutor;
    }

    public OutputLogicExecutionInput withFacetValueResponses(List<ExecutionItem> facetValues) {
        return new OutputLogicExecutionInput(facetValues, this.graphExecutor());
    }

    public List<ExecutionItem> facetValueResponses() {
        return this.facetValueResponses;
    }

    public CompletableFuture[] responseFutures() {
        if (this.responseFutures == null) {
            CompletableFuture[] responseFutures = new CompletableFuture[this.facetValueResponses.size()];
            for (int i = 0; i < this.facetValueResponses.size(); ++i) {
                responseFutures[i] = this.facetValueResponses.get(i).response();
            }
            this.responseFutures = responseFutures;
            return responseFutures;
        }
        return this.responseFutures;
    }

    public ExecutorService graphExecutor() {
        return this.graphExecutor;
    }
}

