/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.Errable;
import com.flipkart.krystal.data.NonNil;
import com.flipkart.krystal.except.StackTracelessException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Failure<T>
implements Errable<T> {
    private final Throwable error;
    private Optional<Throwable> o = Optional.empty();

    public Failure(Throwable error) {
        this.error = error;
    }

    @Override
    public CompletableFuture<@Nullable T> toFuture() {
        return CompletableFuture.failedFuture(this.error);
    }

    @Override
    public @Nullable T value() {
        return null;
    }

    @Override
    public Optional<@NonNull T> valueOptOrThrow() {
        throw this.asRuntimeException();
    }

    @Override
    public @NonNull T valueOrThrow() {
        throw this.asRuntimeException();
    }

    @Override
    public void handle(Consumer<Failure<T>> ifFailure, Runnable ifNil, Consumer<NonNil<T>> ifNonNil) {
        ifFailure.accept(this);
    }

    @Override
    public <U> U map(Function<Failure<T>, U> ifFailure, Supplier<U> ifNil, Function<NonNil<T>, U> ifNonNil) {
        return ifFailure.apply(this);
    }

    @Override
    public Optional<@NonNull T> valueOpt() {
        return Optional.empty();
    }

    public String toString() {
        return this.error.toString();
    }

    public Throwable error() {
        return this.error;
    }

    @Override
    public Optional<Throwable> errorOpt() {
        return this.o.isPresent() ? this.o : (this.o = Optional.of(this.error));
    }

    private RuntimeException asRuntimeException() {
        RuntimeException runtimeException;
        Throwable throwable = this.error;
        if (throwable instanceof RuntimeException) {
            RuntimeException e = (RuntimeException)throwable;
            runtimeException = e;
        } else {
            runtimeException = new StackTracelessException("Failure", this.error);
        }
        return runtimeException;
    }

    public <U> Failure<U> cast() {
        return this;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Failure)) {
            return false;
        }
        Failure other = (Failure)o;
        Throwable this$error = this.error();
        Throwable other$error = other.error();
        return !(this$error == null ? other$error != null : !this$error.equals(other$error));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Throwable $error = this.error();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        return result;
    }
}

