/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.InputValue;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public record ValueOrError<T>(Optional<T> value, Optional<Throwable> error) implements InputValue<T>
{
    private static final ValueOrError<?> EMPTY = new ValueOrError(Optional.empty(), Optional.empty());

    public ValueOrError {
        if (value.isPresent() && error.isPresent()) {
            throw new IllegalArgumentException("Both of 'value' and 'failureReason' cannot be present together");
        }
    }

    public static <T> ValueOrError<T> valueOrError(Callable<T> valueProvider) {
        try {
            return ValueOrError.withValue(valueProvider.call());
        }
        catch (Exception e) {
            return ValueOrError.withError(e);
        }
    }

    public static <S, T> Function<S, ValueOrError<T>> valueOrError(Function<S, T> valueComputer) {
        return s -> ValueOrError.valueOrError(() -> valueComputer.apply(s));
    }

    public static <T> ValueOrError<T> empty() {
        return EMPTY;
    }

    public static <T> ValueOrError<T> withValue(T t) {
        return ValueOrError.valueOrError(t, null);
    }

    public static <T> ValueOrError<T> withError(Throwable t) {
        return ValueOrError.valueOrError(null, t);
    }

    public static <T> ValueOrError<T> valueOrError(Object t, Throwable throwable) {
        Optional o;
        return new ValueOrError<T>(t instanceof Optional ? (o = (Optional)t) : Optional.ofNullable(t), Optional.ofNullable(throwable));
    }

    public CompletableFuture<T> toFuture() {
        if (this.error().isPresent()) {
            return CompletableFuture.failedFuture(this.error().get());
        }
        return CompletableFuture.completedFuture(this.value().orElse(null));
    }

    public Optional<T> getValueOrThrow() throws Exception {
        Optional<Throwable> error = this.error();
        if (error.isPresent()) {
            Throwable throwable = error.get();
            if (throwable instanceof Exception) {
                Exception e = (Exception)throwable;
                throw e;
            }
            throw new RuntimeException(error.get());
        }
        return this.value();
    }

    @Override
    public String toString() {
        if (this.error.isPresent()) {
            return this.error.toString();
        }
        return this.value().toString();
    }
}

