/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.utils;

import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Supplier;

public class MultiLeasePool<T> {
    private final Supplier<T> factory;
    private final int maxActiveLeasesPerObject;
    private double peakAvgActiveLeasesPerObject;
    private int maxPoolSize;
    private final Queue<PooledObject> stack = new LinkedList<PooledObject>();

    public MultiLeasePool(Supplier<T> factory, int maxActiveLeasesPerObject) {
        this.factory = factory;
        this.maxActiveLeasesPerObject = maxActiveLeasesPerObject;
    }

    public final synchronized Lease lease() {
        PooledObject pooledObject = this.stack.poll();
        int count = this.stack.size();
        while (pooledObject != null && count-- > 0 && (pooledObject.shouldDelete() || pooledObject.activeLeases() == this.maxActiveLeasesPerObject)) {
            if (!pooledObject.shouldDelete()) {
                this.stack.add(pooledObject);
            }
            pooledObject = this.stack.poll();
        }
        if (pooledObject == null || pooledObject.activeLeases() == this.maxActiveLeasesPerObject) {
            pooledObject = this.addNewForLeasing();
        } else {
            pooledObject.incrementActiveLeases();
        }
        this.stack.add(pooledObject);
        this.peakAvgActiveLeasesPerObject = Math.max(this.peakAvgActiveLeasesPerObject, this.stack.stream().mapToInt(PooledObject::activeLeases).average().orElse(0.0));
        return new Lease(pooledObject);
    }

    private synchronized void giveBack(PooledObject pooledObject) {
        pooledObject.decrementActiveLeases();
    }

    private PooledObject addNewForLeasing() {
        T t = this.factory.get();
        PooledObject pooledObject = new PooledObject(t);
        pooledObject.incrementActiveLeases();
        this.stack.add(pooledObject);
        this.maxPoolSize = Math.max(this.maxPoolSize, this.stack.size());
        return pooledObject;
    }

    public final int maxActiveLeasesPerObject() {
        return this.maxActiveLeasesPerObject;
    }

    public final double peakAvgActiveLeasesPerObject() {
        return this.peakAvgActiveLeasesPerObject;
    }

    public final int maxPoolSize() {
        return this.maxPoolSize;
    }

    private final class PooledObject {
        private final T ref;
        private int activeLeases = 0;
        private int markForDeletion;

        private PooledObject(T ref) {
            this.ref = ref;
        }

        public T ref() {
            return this.ref;
        }

        public int activeLeases() {
            return this.activeLeases;
        }

        public void incrementActiveLeases() {
            ++this.activeLeases;
        }

        public void decrementActiveLeases() {
            --this.activeLeases;
            this.markForDeletion = this.activeLeases() == 0 && MultiLeasePool.this.maxActiveLeasesPerObject() > 1 ? ++this.markForDeletion : 0;
        }

        public boolean shouldDelete() {
            return this.markForDeletion > 100;
        }
    }

    public final class Lease
    implements AutoCloseable {
        private PooledObject pooledObject;

        private Lease(PooledObject pooledObject) {
            this.pooledObject = pooledObject;
        }

        public T get() {
            if (this.pooledObject == null) {
                throw new IllegalStateException("Lease already released");
            }
            return this.pooledObject.ref();
        }

        @Override
        public void close() {
            if (this.pooledObject != null) {
                MultiLeasePool.this.giveBack(this.pooledObject);
                this.pooledObject = null;
            }
        }
    }
}

