/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.data;

import com.flipkart.krystal.data.InputValue;
import com.flipkart.krystal.data.Results;
import com.flipkart.krystal.data.ValueOrError;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public record Inputs(ImmutableMap<String, InputValue<Object>> values) {
    private static final Inputs EMPTY = new Inputs((ImmutableMap<String, InputValue<Object>>)ImmutableMap.of());

    public Inputs(Map<String, InputValue<Object>> values) {
        this((ImmutableMap<String, InputValue<Object>>)ImmutableMap.copyOf(values));
    }

    public InputValue<?> get(String inputName) {
        return (InputValue)this.values.getOrDefault((Object)inputName, ValueOrError.empty());
    }

    public <T> ValueOrError<T> getInputValue(String inputName) {
        InputValue inputValue = (InputValue)this.values.getOrDefault((Object)inputName, ValueOrError.empty());
        if (inputValue instanceof ValueOrError) {
            ValueOrError voe = (ValueOrError)inputValue;
            return voe;
        }
        throw new IllegalArgumentException();
    }

    public <T> Optional<T> getInputValueOpt(String inputName) {
        return this.getInputValue(inputName).value();
    }

    public <T> T getInputValueOrThrow(String inputName) {
        return this.getInputValueOpt(inputName).orElseThrow();
    }

    public <T> T getInputValueOrDefault(String inputName, T defaultValue) {
        return this.getInputValueOpt(inputName).orElse(defaultValue);
    }

    public <T> Results<T> getDepValue(String inputName) {
        InputValue inputValue = (InputValue)this.values.getOrDefault((Object)inputName, Results.empty());
        if (inputValue instanceof Results) {
            Results voe = (Results)inputValue;
            return voe;
        }
        throw new IllegalArgumentException();
    }

    public static Inputs union(Inputs inputs1, Inputs inputs2) {
        LinkedHashMap<String, InputValue<Object>> v = new LinkedHashMap<String, InputValue<Object>>((Map<String, InputValue<Object>>)inputs1.values());
        v.putAll((Map<String, InputValue<Object>>)inputs2.values());
        return new Inputs(v);
    }

    public static Inputs empty() {
        return EMPTY;
    }

    @Override
    public String toString() {
        return this.values().toString();
    }
}

