/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.utils;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ImmutableMapView<K, V>
extends AbstractMap<K, V> {
    private static final Predicate<Object> DEFAULT_KEY_FILTER = null;
    private static final ImmutableMapView<?, ?> EMPTY = ImmutableMapView.copyOf(ImmutableMap.of());
    private final Map<K, V> delegate;
    private final Predicate<Object> keyFilter;
    private Integer size;
    private Set<K> keySet;
    private Set<Map.Entry<K, V>> entrySet;
    private ImmutableList<V> values;

    private ImmutableMapView(Map<K, V> delegate, @Nullable Predicate<Object> keyFilter) {
        this.delegate = delegate;
        this.keyFilter = keyFilter;
    }

    public static <K, V> ImmutableMapView<K, V> copyOf(Map<K, V> map) {
        return ImmutableMapView.filteredCopyOf(map, DEFAULT_KEY_FILTER);
    }

    public static <K, V> ImmutableMapView<K, V> filteredCopyOf(Map<K, V> map, Predicate<Object> keyFilter) {
        return new ImmutableMapView<K, V>(ImmutableMap.copyOf(map), keyFilter);
    }

    public static <K, V> ImmutableMapView<K, V> copyOf(ImmutableMapView<K, V> map) {
        return ImmutableMapView.filteredCopyOf(map, DEFAULT_KEY_FILTER);
    }

    public static <K, V> ImmutableMapView<K, V> filteredCopyOf(ImmutableMapView<K, V> map, Predicate<Object> keyFilter) {
        return new ImmutableMapView<K, V>(map, keyFilter);
    }

    public static <K, V> ImmutableMapView<K, V> of() {
        return EMPTY;
    }

    @Override
    public int size() {
        if (this.size == null) {
            this.size = this.keyFilter != null ? Integer.valueOf(Math.toIntExact(this.delegate.keySet().stream().filter(this.keyFilter).count())) : Integer.valueOf(this.delegate.size());
        }
        return this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key) && (this.keyFilter == null || this.keyFilter.test(key));
    }

    @Override
    public V get(Object key) {
        if (this.keyFilter != null && !this.keyFilter.test(key)) {
            return null;
        }
        return this.delegate.get(key);
    }

    @Override
    @Deprecated
    public V remove(Object key) {
        return (V)ImmutableMapView.uoe();
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends K, ? extends V> m) {
        ImmutableMapView.uoe();
    }

    @Override
    @Deprecated
    public void clear() {
        ImmutableMapView.uoe();
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = this.keyFilter != null ? (Set<Object>)this.delegate.keySet().stream().filter(this.keyFilter).collect(ImmutableSet.toImmutableSet()) : this.delegate.keySet();
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = this.keyFilter != null ? (Set<Object>)this.delegate.entrySet().stream().filter(e -> this.keyFilter.test(e.getKey())).collect(ImmutableSet.toImmutableSet()) : this.delegate.entrySet();
        }
        return this.entrySet;
    }

    @Override
    public ImmutableCollection<V> values() {
        if (this.values == null) {
            this.values = (ImmutableList)this.entrySet().stream().map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
        }
        return this.values;
    }

    private static <T> T uoe() {
        throw new UnsupportedOperationException();
    }
}

