/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.codegen.common.models;

import com.flipkart.krystal.annos.Generated;
import com.flipkart.krystal.codegen.common.datatypes.CodeGenType;
import com.flipkart.krystal.codegen.common.datatypes.DataTypeRegistry;
import com.flipkart.krystal.codegen.common.models.CodeGenerationException;
import com.flipkart.krystal.codegen.common.models.CodeValidationException;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.models.TypeAndName;
import com.flipkart.krystal.codegen.common.models.TypeNameVisitor;
import com.flipkart.krystal.datatypes.JavaType;
import com.flipkart.krystal.model.IfAbsent;
import com.flipkart.krystal.model.ModelProtocol;
import com.flipkart.krystal.model.ModelRoot;
import com.flipkart.krystal.model.SupportedModelProtocols;
import com.flipkart.krystal.serial.SerdeProtocol;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor14;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import lombok.ToString;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenUtility {
    @lombok.Generated
    private static final Logger log = LoggerFactory.getLogger(CodeGenUtility.class);
    private static final boolean NOTE_LEVEL = System.getProperty("krystal.codegen.logLevel", "error").equalsIgnoreCase("note");
    private final ProcessingEnvironment processingEnv;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final Class<?> generator;
    private final @Nullable CodegenPhase codegenPhase;
    private final DataTypeRegistry dataTypeRegistry;

    public CodeGenUtility(ProcessingEnvironment processingEnv, Class<?> generator, @Nullable CodegenPhase codegenPhase) {
        this.processingEnv = processingEnv;
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.generator = generator;
        this.codegenPhase = codegenPhase;
        this.dataTypeRegistry = new DataTypeRegistry();
    }

    public static String capitalizeFirstChar(String str) {
        return str.isEmpty() ? str : Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String lowerCaseFirstChar(String str) {
        return str.isEmpty() ? str : Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public String getPackageName(Element element) {
        return Objects.requireNonNull(this.processingEnv().getElementUtils().getPackageOf(element)).getQualifiedName().toString();
    }

    public void addImmutableModelObjectMethods(ClassName immutInterfaceName, Set<? extends CharSequence> modelFieldNames, TypeSpec.Builder classBuilder) {
        CodeGenUtility.addCommonObjectMethods(classBuilder);
        classBuilder.addMethod(MethodSpec.overriding((ExecutableElement)this.getMethod(Object.class, "equals", 1)).addCode("if (this == obj) {\n  return true;\n}\nif (!(obj instanceof $T other)) {\n  return false;\n}\nreturn $L;\n", new Object[]{immutInterfaceName, modelFieldNames.isEmpty() ? "true" : modelFieldNames.stream().map(name -> CodeBlock.of((String)"$T.equals(this.$L(), other.$L())", (Object[])new Object[]{Objects.class, name, name})).collect(CodeBlock.joining((String)"\n&& "))}).build());
        classBuilder.addField(Integer.TYPE, "_memoizedHashCode", new Modifier[]{Modifier.PRIVATE});
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addAnnotation(Override.class).addCode("if(_memoizedHashCode == 0) { _memoizedHashCode =  $T.hash($L); }", new Object[]{Objects.class, modelFieldNames.stream().map(Object::toString).sorted().map(name -> CodeBlock.of((String)"this.$L()", (Object[])new Object[]{name})).collect(CodeBlock.joining((String)",\n"))}).addStatement("return _memoizedHashCode", new Object[0]).build());
    }

    public static void addCommonObjectMethods(TypeSpec.Builder classBuilder) {
        classBuilder.addAnnotation(AnnotationSpec.builder(ToString.class).addMember("doNotUseGetters", "true", new Object[0]).build());
    }

    public static List<AnnotationSpec> annotations(Class<?> ... annotations) {
        return Arrays.stream(annotations).map(aClass -> AnnotationSpec.builder((Class)aClass).build()).toList();
    }

    public IfAbsent getIfAbsent(Element element) {
        IfAbsent ifAbsent = element.getAnnotation(IfAbsent.class);
        if (ifAbsent == null) {
            ifAbsent = IfAbsent.Creator.create((IfAbsent.IfAbsentThen)IfAbsent.IfAbsentThen.WILL_NEVER_FAIL, (String)"");
        }
        return ifAbsent;
    }

    public List<ExecutableElement> extractAndValidateModelMethods(TypeElement modelRootType) {
        ArrayList<ExecutableElement> modelMethods = new ArrayList<ExecutableElement>();
        for (ExecutableElement executableElem : ElementFilter.methodsIn(this.processingEnv.getElementUtils().getAllMembers(modelRootType))) {
            if (!ElementKind.METHOD.equals((Object)executableElem.getKind()) || !executableElem.getModifiers().contains((Object)Modifier.ABSTRACT) || executableElem.getSimpleName().toString().startsWith("_")) continue;
            this.validateGetterMethod(executableElem);
            modelMethods.add(executableElem);
        }
        return modelMethods;
    }

    private void validateGetterMethod(ExecutableElement method) {
        TypeMirror returnType;
        if (!method.getParameters().isEmpty()) {
            this.error("Model root methods must have zero parameters: " + String.valueOf(method.getSimpleName()), method);
        }
        if ((returnType = method.getReturnType()).getKind() == TypeKind.VOID) {
            this.error("Model root methods must have a return type (not void): " + String.valueOf(method.getSimpleName()), method);
        }
        if (returnType.getKind() == TypeKind.ARRAY) {
            this.error("Model root methods must not return arrays. Use List instead.", method);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAnyNullable(TypeMirror type, Element elementToCheck) {
        if (this.isAnyNullable(type::getAnnotationMirrors)) return true;
        if (!this.isAnyNullable(elementToCheck::getAnnotationMirrors)) return false;
        return true;
    }

    private boolean isAnyNullable(Supplier<List<? extends AnnotationMirror>> annotationMirrors) {
        return annotationMirrors.get().stream().map(AnnotationMirror::getAnnotationType).map(DeclaredType::asElement).anyMatch(element -> element.getSimpleName().contentEquals("Nullable"));
    }

    public boolean isOptional(TypeMirror returnType) {
        return this.isRawAssignable(returnType, Optional.class);
    }

    public TypeMirror getOptionalInnerType(TypeMirror optionalType) {
        DeclaredType declaredType;
        if (!this.isOptional(optionalType)) {
            return optionalType;
        }
        if (optionalType instanceof DeclaredType && !(declaredType = (DeclaredType)optionalType).getTypeArguments().isEmpty()) {
            return declaredType.getTypeArguments().get(0);
        }
        return Objects.requireNonNull(this.processingEnv().getElementUtils().getTypeElement(Object.class.getCanonicalName())).asType();
    }

    @Nullable String getDisallowedMessage(TypeMirror type, ImmutableMap<Class<?>, String> disallowedTypes) {
        return disallowedTypes.entrySet().stream().map(e -> {
            if (CodeGenUtility.isRawAssignable(type, (Class)e.getKey(), this.processingEnv())) {
                return (String)e.getValue();
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static boolean isRawAssignable(TypeMirror from, Class<?> to, ProcessingEnvironment processingEnv) {
        Types typeUtils = processingEnv.getTypeUtils();
        return typeUtils.isAssignable(typeUtils.erasure(from), typeUtils.erasure(CodeGenUtility.getTypeElement((String)Preconditions.checkNotNull((Object)to.getCanonicalName()), processingEnv).asType()));
    }

    public static TypeElement getTypeElement(String name, ProcessingEnvironment processingEnv) {
        TypeElement typeElement = processingEnv.getElementUtils().getTypeElement(name);
        if (typeElement == null) {
            throw new IllegalStateException("Could not find type element with name %s".formatted(name));
        }
        return typeElement;
    }

    public void generateSourceFile(String canonicalClassName, JavaFile code, TypeElement originatingElement) {
        StringWriter writer = new StringWriter();
        try {
            code.writeTo((Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.generateSourceFile(canonicalClassName, writer.toString(), originatingElement);
    }

    public void generateSourceFile(String canonicalClassName, String code, @Nullable TypeElement originatingElement) {
        try {
            JavaFileObject requestFile = this.processingEnv.getFiler().createSourceFile(canonicalClassName, (Element[])Optional.ofNullable(originatingElement).stream().toArray(Element[]::new));
            this.note("Successfully created source file %s".formatted(canonicalClassName));
            try (PrintWriter out = new PrintWriter(requestFile.openWriter());){
                out.println(code);
            }
        }
        catch (Exception e) {
            this.error("Error creating java file for className: %s. Error: %s".formatted(canonicalClassName, e), originatingElement);
        }
    }

    public Optional<TypeMirror> getTypeFromAnnotationMember(Supplier<Class<?>> supplier) {
        try {
            Class<?> ignored = supplier.get();
            throw new AssertionError((Object)"Expected supplier to throw error");
        }
        catch (MirroredTypeException mte) {
            return Optional.ofNullable(mte.getTypeMirror());
        }
    }

    public List<? extends TypeMirror> getTypesFromAnnotationMember(Supplier<Class<?>[]> supplier) {
        try {
            Class<?>[] ignored = supplier.get();
            return List.of();
        }
        catch (MirroredTypesException mte) {
            return mte.getTypeMirrors();
        }
    }

    public ImmutableList<TypeMirror> getTypeParamTypes(TypeElement childTypeElement, TypeElement targetParentClass) {
        List<TypeMirror> currentTypes = List.of(childTypeElement.asType());
        Types typeUtils = this.processingEnv.getTypeUtils();
        DeclaredType targetType = null;
        do {
            ArrayList<TypeMirror> newSuperTypes = new ArrayList<TypeMirror>();
            block1: for (TypeMirror currentType : currentTypes) {
                List<DeclaredType> superTypes = this.processingEnv.getTypeUtils().directSupertypes(currentType).stream().filter(t -> t instanceof DeclaredType).map(t -> (DeclaredType)t).toList();
                newSuperTypes.addAll(superTypes);
                for (DeclaredType superType : superTypes) {
                    TypeElement typeElement;
                    Element element = typeUtils.asElement(superType);
                    if (!(element instanceof TypeElement) || !(typeElement = (TypeElement)element).getQualifiedName().contentEquals(targetParentClass.getQualifiedName())) continue;
                    targetType = superType;
                    continue block1;
                }
            }
            if (targetType != null) continue;
            currentTypes = newSuperTypes;
        } while (!currentTypes.isEmpty() && targetType == null);
        if (targetType != null) {
            return ImmutableList.copyOf(CodeGenUtility.getTypeMirrors(targetType));
        }
        return ImmutableList.of();
    }

    private static List<? extends TypeMirror> getTypeMirrors(DeclaredType targetType) {
        return targetType.getTypeArguments();
    }

    public void note(CharSequence message) {
        this._note(message, null);
    }

    public void note(CharSequence message, @Nullable TypeElement typeElement) {
        this._note(message, typeElement);
    }

    private void _note(CharSequence message, @Nullable TypeElement typeElement) {
        if (NOTE_LEVEL) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[%s] [%s] %s".formatted(CodeGenUtility.getCallerInfo(), String.valueOf((Object)this.codegenPhase), message), typeElement);
        }
    }

    public CodeValidationException errorAndThrow(String message, Element ... elements) {
        this._error(message, elements);
        return new CodeValidationException(message);
    }

    public void error(String message, Element ... elements) {
        this._error(message, elements);
    }

    private void _error(String message, Element ... elements) {
        String enrichedMessage = "[%s] [%s:%s] %s".formatted(CodeGenUtility.getCallerInfo(), this.generator, String.valueOf((Object)this.codegenPhase), message);
        if (elements.length == 0) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, enrichedMessage);
        } else {
            for (Element element : elements) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, enrichedMessage, element);
            }
        }
    }

    private static String getCallerInfo() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length > 4) {
            StringBuilder callerInfo = new StringBuilder();
            for (int i = Math.min(5, stackTrace.length - 1); i >= 4; --i) {
                StackTraceElement stackTraceElement = stackTrace[i];
                String fullClassName = stackTraceElement.getClassName();
                callerInfo.append(fullClassName.substring(fullClassName.lastIndexOf(46) + 1)).append(":").append(stackTraceElement.getMethodName()).append(":").append(stackTraceElement.getLineNumber()).append("=>");
            }
            return callerInfo.toString();
        }
        throw new AssertionError();
    }

    private String getTimestamp() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.now(ZoneId.of((String)Preconditions.checkNotNull((Object)ZoneId.SHORT_IDS.get("IST")))));
    }

    public TypeName toTypeName(CodeGenType dataType) {
        return TypeName.get((TypeMirror)dataType.javaModelType(this.processingEnv));
    }

    public static TypeName toTypeName(Type typeArg) {
        if (typeArg instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)typeArg;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArgs = parameterizedType.getActualTypeArguments();
            return ParameterizedTypeName.get((ClassName)((ClassName)CodeGenUtility.toTypeName(rawType)), (TypeName[])((TypeName[])Arrays.stream(typeArgs).map(CodeGenUtility::toTypeName).toArray(TypeName[]::new)));
        }
        if (typeArg instanceof Class) {
            return ClassName.get((Class)Primitives.wrap((Class)((Class)typeArg)));
        }
        return ClassName.bestGuess((String)typeArg.getTypeName());
    }

    public static List<? extends TypeMirror> getTypeParameters(TypeMirror returnType) {
        return returnType.accept(new SimpleTypeVisitor14<List<? extends TypeMirror>, Void>(){

            @Override
            public List<? extends TypeMirror> visitDeclared(DeclaredType t, Void unused) {
                return t.getTypeArguments();
            }
        }, null);
    }

    public boolean isSameRawType(TypeMirror a, Class<?> b) {
        return this.processingEnv.getTypeUtils().isSameType(this.typeUtils.erasure(a), this.typeUtils.erasure(((TypeElement)Preconditions.checkNotNull((Object)this.processingEnv().getElementUtils().getTypeElement((CharSequence)Preconditions.checkNotNull((Object)b.getCanonicalName())), (Object)("TypeElement not found for: " + b.getCanonicalName()))).asType()));
    }

    public boolean isRawAssignable(TypeMirror from, Class<?> to) {
        return CodeGenUtility.isRawAssignable(from, to, this.processingEnv());
    }

    public TypeMirror box(TypeMirror type) {
        if (type instanceof PrimitiveType) {
            PrimitiveType p = (PrimitiveType)type;
            return this.typeUtils.boxedClass(p).asType();
        }
        if (type.getKind() == TypeKind.VOID) {
            return Objects.requireNonNull(this.elementUtils.getTypeElement(Objects.requireNonNull(Void.class.getCanonicalName()))).asType();
        }
        return type;
    }

    private void addDefaultAnnotations(TypeSpec.Builder classBuilder) {
        classBuilder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", (CodeBlock)Stream.of(CodeBlock.of((String)"$S", (Object[])new Object[]{"unchecked"}), CodeBlock.of((String)"$S", (Object[])new Object[]{"ClassReferencesSubclass"})).collect(CodeBlock.joining((String)",", (String)"{", (String)"}"))).build());
        this.addGeneratedAnnotations(classBuilder);
    }

    public void addGeneratedAnnotations(TypeSpec.Builder classBuilder) {
        classBuilder.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("by", "$S", new Object[]{this.generator.getName()}).build()).addAnnotation(AnnotationSpec.builder(javax.annotation.processing.Generated.class).addMember("value", "$S", new Object[]{this.generator.getName()}).addMember("date", "$S", new Object[]{this.getTimestamp()}).build());
    }

    public TypeSpec.Builder classBuilder(String simpleName, String generatedForCanonicalName) {
        return this.classBuilder(simpleName, List.of(), generatedForCanonicalName);
    }

    public TypeSpec.Builder classBuilder(String simpleName, List<TypeVariableName> typeVariableNames, String generatedForCanonicalName) {
        TypeSpec.Builder classBuilder = simpleName.isBlank() ? TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]) : TypeSpec.classBuilder((String)simpleName);
        if (!generatedForCanonicalName.isBlank()) {
            classBuilder.addJavadoc("@see $L", new Object[]{generatedForCanonicalName});
        }
        classBuilder.addTypeVariables(typeVariableNames);
        this.addDefaultAnnotations(classBuilder);
        return classBuilder;
    }

    public TypeSpec.Builder interfaceBuilder(String interfaceName, String generatedForCanonicalName) {
        return this.interfaceBuilder(interfaceName, List.of(), generatedForCanonicalName);
    }

    public TypeSpec.Builder interfaceBuilder(String interfaceName, List<TypeVariableName> typeVariableNames, String generatedForCanonicalName) {
        if (interfaceName.isBlank()) {
            throw new RuntimeException("interface name cannot be blank");
        }
        TypeSpec.Builder interfaceBuilder = TypeSpec.interfaceBuilder((String)interfaceName);
        interfaceBuilder.addTypeVariables(typeVariableNames);
        this.addDefaultAnnotations(interfaceBuilder);
        if (!generatedForCanonicalName.isBlank()) {
            interfaceBuilder.addJavadoc("@see $L", new Object[]{generatedForCanonicalName});
        }
        return interfaceBuilder;
    }

    public TypeAndName box(TypeAndName javaType) {
        @Nullable TypeMirror typeMirror = javaType.type();
        if (typeMirror == null) {
            return javaType;
        }
        TypeKind typeKind = typeMirror.getKind();
        if (!typeKind.isPrimitive() && typeKind != TypeKind.VOID) {
            return javaType;
        }
        TypeMirror boxed = typeKind == TypeKind.VOID ? Objects.requireNonNull(this.processingEnv.getElementUtils().getTypeElement(Void.class.getCanonicalName())).asType() : this.processingEnv.getTypeUtils().boxedClass((PrimitiveType)typeMirror).asType();
        return new TypeAndName(TypeName.get((TypeMirror)boxed).annotated(javaType.annotationSpecs()), boxed, javaType.annotationSpecs());
    }

    public TypeAndName getTypeName(CodeGenType dataType, List<AnnotationSpec> typeAnnotations) {
        TypeMirror javaModelType = dataType.javaModelType(this.processingEnv);
        return new TypeAndName(TypeName.get((TypeMirror)javaModelType).annotated(typeAnnotations), javaModelType, typeAnnotations);
    }

    public TypeAndName getTypeName(CodeGenType dataType) {
        return this.getTypeName(dataType, List.of());
    }

    public ExecutableElement getMethod(Callable<Method> methodSupplier) {
        Method method = methodSupplier.call();
        TypeElement typeElement = Objects.requireNonNull(this.processingEnv().getElementUtils().getTypeElement(Objects.requireNonNull(method.getDeclaringClass().getCanonicalName())));
        int parameterCount = method.getParameterCount();
        return typeElement.getEnclosedElements().stream().filter(element -> element instanceof ExecutableElement).map(element -> (ExecutableElement)element).filter(element -> element.getSimpleName().contentEquals(method.getName()) && element.getParameters().size() == parameterCount && IntStream.range(0, parameterCount).allMatch(i -> this.isSameRawType(element.getParameters().get(i).asType(), method.getParameterTypes()[i]))).findFirst().orElseThrow(() -> new CodeGenerationException("Method " + String.valueOf(method) + " not found"));
    }

    public ExecutableElement getMethod(Class<?> clazz, String methodName, int paramCount) {
        return this.getMethod(Objects.requireNonNull(this.processingEnv().getElementUtils().getTypeElement(Objects.requireNonNull(clazz.getCanonicalName()))), methodName, paramCount).orElseThrow(() -> new IllegalArgumentException("Could not find method '" + methodName + "' with param count '" + paramCount + "' in class " + String.valueOf(clazz)));
    }

    public Optional<ExecutableElement> getMethod(TypeElement typeElement, String methodName, int paramCount) {
        return typeElement.getEnclosedElements().stream().filter(element -> element instanceof ExecutableElement).map(element -> (ExecutableElement)element).filter(element -> element.getSimpleName().contentEquals(methodName) && element.getParameters().size() == paramCount).findAny();
    }

    public String getJavaTypeCreationCode(CodeGenType javaType, List<TypeName> collectClassNames) {
        TypeMirror typeMirror = javaType.javaModelType(this.processingEnv);
        collectClassNames.add((TypeName)ClassName.get(JavaType.class));
        if (javaType.typeParameters().isEmpty()) {
            collectClassNames.add(TypeName.get((TypeMirror)typeMirror));
            return "$T.create($T.class)";
        }
        collectClassNames.add(TypeName.get((TypeMirror)this.processingEnv.getTypeUtils().erasure(typeMirror)));
        return "$T.create($T.class, " + javaType.typeParameters().stream().map(dataType -> this.getJavaTypeCreationCode((CodeGenType)dataType, collectClassNames)).collect(Collectors.joining(",")) + ")";
    }

    public Path detectSourceOutputPath(@Nullable Element codeGenElement) {
        Path sourcePath;
        try {
            FileObject dummyFile = this.processingEnv().getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", new Random().nextInt() + "_dummy_detect_source_path.txt", new Element[0]);
            sourcePath = Paths.get(dummyFile.toUri());
            dummyFile.delete();
        }
        catch (Exception e) {
            throw this.errorAndThrow("Could not detect source output directory because dummy_detect_source_path.txt could not be created", codeGenElement);
        }
        return Objects.requireNonNull(sourcePath.getParent());
    }

    public <T> T getAnnotationElement(AnnotationMirror parentModelRootAnno, String annoElement, Class<T> type) {
        return type.cast(this.elementUtils.getElementValuesWithDefaults(parentModelRootAnno).entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals(annoElement)).findAny().map(Map.Entry::getValue).orElseThrow(AssertionError::new).getValue());
    }

    public TypeName optional(TypeAndName javaType) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{this.box(javaType).typeName()});
    }

    public ClassName getImmutClassName(TypeElement modelRootType) {
        ModelRoot modelRoot = modelRootType.getAnnotation(ModelRoot.class);
        if (modelRoot == null) {
            throw new IllegalArgumentException("Cannot fetch Immut class name for Model which does not have @ModelRoot annotation");
        }
        String modelRootName = modelRootType.getSimpleName().toString();
        String packageName = this.getPackageName(modelRootType);
        return ClassName.get((String)packageName, (String)(modelRootName + modelRoot.suffixSeparator() + "Immut"), (String[])new String[0]);
    }

    public ClassName getImmutSerdeClassName(TypeElement modelRootType, SerdeProtocol serdeProtocol) {
        ClassName immutClassName = this.getImmutClassName(modelRootType);
        return ClassName.get((String)immutClassName.packageName(), (String)(immutClassName.simpleName() + serdeProtocol.modelClassesSuffix()), (String[])new String[0]);
    }

    public void writeJavaFile(String packageName, TypeSpec typeSpec, TypeElement originatingElement) {
        try {
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
            String fileName = packageName + "." + typeSpec.name;
            this.generateSourceFile(fileName, javaFile.toString(), originatingElement);
        }
        catch (Exception e) {
            this.error("Error generating Java file: " + e.getMessage(), originatingElement);
        }
    }

    public TypeName getParameterType(ExecutableElement method, boolean isBuilder) {
        TypeMirror specifiedType;
        TypeMirror inferredType = specifiedType = method.getReturnType();
        if (this.isOptional(specifiedType)) {
            inferredType = this.getOptionalInnerType(specifiedType);
        }
        if (isBuilder && inferredType instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)inferredType;
            inferredType = this.typeUtils.boxedClass(primitiveType).asType();
        }
        TypeName typeName = inferredType.accept(new TypeNameVisitor(), null);
        if (this.isOptional(specifiedType)) {
            typeName = typeName.annotated(new AnnotationSpec[]{AnnotationSpec.builder((ClassName)ClassName.get(Nullable.class)).build()});
        }
        return typeName;
    }

    public boolean typeExplicitlySupportsProtocol(TypeElement modelRootType, Class<? extends ModelProtocol> modelProtocol) {
        SupportedModelProtocols supportedModelProtocols = modelRootType.getAnnotation(SupportedModelProtocols.class);
        if (supportedModelProtocols == null) {
            return false;
        }
        return this.getTypesFromAnnotationMember(() -> ((SupportedModelProtocols)supportedModelProtocols).value()).stream().map(typeMirror -> this.processingEnv().getTypeUtils().asElement((TypeMirror)typeMirror)).filter(elem -> elem instanceof QualifiedNameable).map(element -> Objects.requireNonNull((QualifiedNameable)element).getQualifiedName().toString()).anyMatch(s -> Objects.equals(s, modelProtocol.getCanonicalName()));
    }

    @lombok.Generated
    public ProcessingEnvironment processingEnv() {
        return this.processingEnv;
    }

    @lombok.Generated
    public @Nullable CodegenPhase codegenPhase() {
        return this.codegenPhase;
    }

    @lombok.Generated
    public DataTypeRegistry dataTypeRegistry() {
        return this.dataTypeRegistry;
    }
}

