/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.codegen.common.datatypes;

import com.flipkart.krystal.codegen.common.datatypes.CodeGenType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.CodeBlock;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import lombok.Generated;

public enum StandardJavaType implements CodeGenType
{
    BOOLEAN(TypeKind.BOOLEAN, CodeBlock.of((String)"false", (Object[])new Object[0]), Boolean.TYPE.getCanonicalName(), Boolean.class.getCanonicalName()),
    INT(TypeKind.INT, CodeBlock.of((String)"0", (Object[])new Object[0]), Integer.TYPE.getCanonicalName(), Integer.class.getCanonicalName()),
    BYTE(TypeKind.BYTE, CodeBlock.of((String)"0", (Object[])new Object[0]), Byte.TYPE.getCanonicalName(), Byte.class.getCanonicalName()),
    SHORT(TypeKind.SHORT, CodeBlock.of((String)"0", (Object[])new Object[0]), Short.TYPE.getCanonicalName(), Short.class.getCanonicalName()),
    LONG(TypeKind.LONG, CodeBlock.of((String)"0L", (Object[])new Object[0]), Long.TYPE.getCanonicalName(), Long.class.getCanonicalName()),
    CHAR(TypeKind.CHAR, CodeBlock.of((String)"0", (Object[])new Object[0]), Character.TYPE.getCanonicalName(), Character.class.getCanonicalName()),
    FLOAT(TypeKind.FLOAT, CodeBlock.of((String)"0.0f", (Object[])new Object[0]), Float.TYPE.getCanonicalName(), Float.class.getCanonicalName()),
    DOUBLE(TypeKind.DOUBLE, CodeBlock.of((String)"0.0d", (Object[])new Object[0]), Double.TYPE.getCanonicalName(), Double.class.getCanonicalName()),
    VOID(CodeBlock.of((String)"null", (Object[])new Object[0]), processingEnv -> processingEnv.getTypeUtils().getNoType(TypeKind.VOID), Void.TYPE.getCanonicalName(), Void.class.getCanonicalName()),
    STRING(TypeKind.DECLARED, CodeBlock.of((String)"$S", (Object[])new Object[]{""}), String.class.getCanonicalName(), new String[0]),
    LIST_RAW(TypeKind.DECLARED, CodeBlock.of((String)"$T.of()", (Object[])new Object[]{List.class}), List.class.getCanonicalName(), new String[0]),
    MAP_RAW(TypeKind.DECLARED, CodeBlock.of((String)"$T.of()", (Object[])new Object[]{Map.class}), Map.class.getCanonicalName(), new String[0]);

    static final ImmutableMap<String, StandardJavaType> standardTypesByCanonicalName;
    private final CodeBlock defaultValueExpr;
    private final Function<ProcessingEnvironment, TypeMirror> getJavaModelType;
    private final String defaultCanonicalClassName;
    private final ImmutableList<String> canonicalClassNames;

    private StandardJavaType(TypeKind typeKind, CodeBlock defaultValueExpr, String defaultCanonicalClassName, String ... canonicalClassNames) {
        this(defaultValueExpr, (ProcessingEnvironment processingEnv) -> {
            if (typeKind.isPrimitive()) {
                return processingEnv.getTypeUtils().getPrimitiveType(typeKind);
            }
            return processingEnv.getTypeUtils().erasure(Objects.requireNonNull(processingEnv.getElementUtils().getTypeElement(defaultCanonicalClassName)).asType());
        }, defaultCanonicalClassName, canonicalClassNames);
    }

    private StandardJavaType(CodeBlock defaultValueExpr, Function<ProcessingEnvironment, TypeMirror> getJavaModelType, String defaultCanonicalClassName, String ... otherCanonicalClassNames) {
        this.defaultValueExpr = defaultValueExpr;
        this.getJavaModelType = getJavaModelType;
        this.defaultCanonicalClassName = defaultCanonicalClassName;
        this.canonicalClassNames = ImmutableList.builder().add((Object)defaultCanonicalClassName).add((Object[])otherCanonicalClassNames).build();
    }

    @Override
    public String canonicalClassName() {
        return this.defaultCanonicalClassName;
    }

    @Override
    public TypeMirror javaModelType(ProcessingEnvironment processingEnv) {
        return this.getJavaModelType.apply(processingEnv);
    }

    @Override
    public ImmutableList<CodeGenType> typeParameters() {
        return ImmutableList.of();
    }

    @Override
    public CodeGenType rawType() {
        return this;
    }

    @Override
    public CodeBlock defaultValueExpr(ProcessingEnvironment processingEnv) {
        return this.defaultValueExpr;
    }

    @Generated
    public CodeBlock defaultValueExpr() {
        return this.defaultValueExpr;
    }

    @Generated
    public Function<ProcessingEnvironment, TypeMirror> getJavaModelType() {
        return this.getJavaModelType;
    }

    @Generated
    public String defaultCanonicalClassName() {
        return this.defaultCanonicalClassName;
    }

    @Generated
    public ImmutableList<String> canonicalClassNames() {
        return this.canonicalClassNames;
    }

    static {
        LinkedHashMap<String, StandardJavaType> collector = new LinkedHashMap<String, StandardJavaType>();
        for (StandardJavaType standardJavaType : StandardJavaType.values()) {
            for (String canonicalClassName : standardJavaType.canonicalClassNames()) {
                collector.put(canonicalClassName, standardJavaType);
            }
        }
        standardTypesByCanonicalName = ImmutableMap.copyOf(collector);
    }
}

