/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.krystal.codegen.common.models;

import com.flipkart.krystal.codegen.common.models.CodeGenUtility;
import com.flipkart.krystal.codegen.common.models.CodegenPhase;
import com.flipkart.krystal.codegen.common.models.RunOnlyWhenCodegenPhaseIs;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKrystalAnnoProcessor
extends AbstractProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractKrystalAnnoProcessor.class);
    private final @Nullable CodegenPhase expectedPhase;
    private @MonotonicNonNull CodeGenUtility codeGenUtil;
    private @MonotonicNonNull CodegenPhase codegenPhase;

    protected CodeGenUtility codeGenUtil() {
        return Objects.requireNonNull(this.codeGenUtil, "Codegen util is accessible only in the processing phase");
    }

    public CodegenPhase codegenPhase() {
        return Objects.requireNonNull(this.codegenPhase, "Codegen phase is accessible only in the processing phase");
    }

    public AbstractKrystalAnnoProcessor() {
        RunOnlyWhenCodegenPhaseIs runOnlyWhenCodegenPhaseIs = this.getClass().getAnnotation(RunOnlyWhenCodegenPhaseIs.class);
        this.expectedPhase = runOnlyWhenCodegenPhaseIs == null ? null : runOnlyWhenCodegenPhaseIs.value();
        log.info("Initializing {} with codegen phase {}", (Object)this.getClass().getSimpleName(), (Object)this.expectedPhase);
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.validateAndInit();
        if (this.expectedPhase == null || Objects.equals((Object)this.expectedPhase, (Object)this.codegenPhase)) {
            return this.processImpl(annotations, roundEnv);
        }
        Objects.requireNonNull(this.codeGenUtil).note("Skipping %s since codegen phase is '%s'. This class only supports '%s'".formatted(new Object[]{this.getClass().getSimpleName(), this.codegenPhase, this.expectedPhase}));
        return false;
    }

    private void validateAndInit() {
        this.validateCodegenPhase();
    }

    private void validateCodegenPhase() {
        String currentPhaseString = this.processingEnv.getOptions().get("krystal.codegen.phase");
        if (currentPhaseString == null) {
            return;
        }
        try {
            this.codegenPhase = CodegenPhase.valueOf(currentPhaseString);
        }
        catch (IllegalArgumentException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "%s could not parse phase string '%s'. Exactly one of %s must be passed as value to the java compiler via the annotation processor argument '-A%s='".formatted(this.getClass().getSimpleName(), String.valueOf(currentPhaseString), Arrays.toString((Object[])CodegenPhase.values()), "krystal.codegen.phase"));
        }
        this.codeGenUtil = new CodeGenUtility(this.processingEnv, this.getClass(), this.codegenPhase);
    }

    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return false;
    }
}

