/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class BufferQueueEntry {
    private static final HashFunction checksum = Hashing.crc32();
    private static final int CHECKSUM_BYTES = checksum.bits() / 8;
    @VisibleForTesting
    static final int OFFSET_LENGTH = 0;
    @VisibleForTesting
    static final int OFFSET_CHECKSUM = 32;
    @VisibleForTesting
    static final int OFFSET_DATA = 32 + CHECKSUM_BYTES;

    protected abstract ByteBuffer getByteBuffer();

    public void set(byte[] data) throws BufferOverflowException {
        if (this.isPublishedUnconsumed()) {
            throw new IllegalStateException("The given buffer entry has already been marked as published and cannot be written to");
        }
        ByteBuffer buf = this.getByteBuffer();
        if (BufferQueueEntry.calculateEntryLength(data.length) > buf.limit()) {
            throw new BufferOverflowException();
        }
        buf.putInt(0, data.length);
        buf.position(32);
        buf.put(checksum.hashBytes(data).asBytes());
        buf.position(OFFSET_DATA);
        buf.put(data);
        buf.flip();
    }

    public abstract void markPublishedUnconsumed();

    public abstract boolean isPublishedUnconsumed();

    public int dataLength() {
        if (!this.isPublishedUnconsumed()) {
            return -1;
        }
        return this.getByteBuffer().getInt(0);
    }

    public int maxDataLength() {
        return this.getByteBuffer().capacity() - OFFSET_DATA;
    }

    public byte[] get() {
        if (this.isConsumed()) {
            throw new IllegalStateException("The buffer queue entry has already been marked as consumed, so cannot be read from");
        }
        int length = this.dataLength();
        if (!this.isPublishedUnconsumed() || length > this.maxDataLength() || length <= 0) {
            return new byte[0];
        }
        ByteBuffer buf = this.getByteBuffer();
        byte[] checksumBytes = new byte[CHECKSUM_BYTES];
        buf.position(32);
        buf.get(checksumBytes);
        byte[] data = new byte[length];
        buf.position(OFFSET_DATA);
        buf.get(data);
        if (!Arrays.equals(checksum.hashBytes(data).asBytes(), checksumBytes)) {
            return new byte[0];
        }
        return data;
    }

    public abstract void markConsumed();

    public abstract boolean isConsumed();

    public static int calculateEntryLength(int messageDataLength) {
        return OFFSET_DATA + messageDataLength;
    }

    public static int metadataOverhead() {
        return OFFSET_DATA;
    }
}

