/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue;

import com.flipkart.iris.bufferqueue.BufferQueueEntry;
import com.google.common.base.Optional;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.List;

public interface BufferQueue {
    public Publisher publisher() throws IllegalStateException, IOException;

    public Consumer consumer() throws IllegalStateException, IOException;

    public void close() throws IOException;

    public int maxDataLength() throws IOException;

    public long maxNumEntries();

    public long size() throws IOException;

    public boolean isFull() throws IOException;

    public boolean isEmpty() throws IOException;

    public static class ClosedBufferQueueException
    extends RuntimeException {
        public ClosedBufferQueueException() {
            super("Attempting to use a closed BufferQueue");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Consumer {
        public BufferQueue bufferQueue() throws IOException;

        public Optional<? extends BufferQueueEntry> peek() throws IOException;

        public List<? extends BufferQueueEntry> peek(int var1) throws IOException;

        public Optional<byte[]> consume() throws IOException;

        public List<byte[]> consume(int var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Publisher {
        public BufferQueue bufferQueue() throws IOException;

        public Optional<? extends BufferQueueEntry> claim() throws IOException;

        public Optional<? extends BufferQueueEntry> claimFor(int var1) throws IOException;

        public boolean publish(byte[] var1) throws BufferOverflowException, IOException;
    }
}

