/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class BufferQueueEntry {
    private static final HashFunction checksum = Hashing.crc32();
    private static final int CHECKSUM_BYTES = checksum.bits() / 8;
    @VisibleForTesting
    static final int OFFSET_LENGTH = 0;
    @VisibleForTesting
    static final int OFFSET_CHECKSUM = 32;
    @VisibleForTesting
    static final int OFFSET_DATA = 32 + CHECKSUM_BYTES;
    private final ByteBuffer buf;

    public BufferQueueEntry(ByteBuffer buf) {
        this.buf = buf;
    }

    public void set(byte[] data) throws BufferOverflowException {
        if (this.isPublished()) {
            throw new IllegalStateException("The given buffer entry has already been marked as published and cannot be written to");
        }
        if (BufferQueueEntry.calculateEntryLength(data.length) > this.buf.limit()) {
            throw new BufferOverflowException();
        }
        this.buf.putInt(0, data.length);
        this.buf.position(32);
        this.buf.put(checksum.hashBytes(data).asBytes());
        this.buf.position(OFFSET_DATA);
        this.buf.put(data);
        this.buf.flip();
    }

    public abstract void markPublished();

    public abstract boolean isPublished();

    public int dataLength() {
        if (!this.isPublished()) {
            return -1;
        }
        return this.buf.getInt(0);
    }

    public int maxDataLength() {
        return this.buf.capacity() - OFFSET_DATA;
    }

    public byte[] get() {
        if (this.isConsumed()) {
            throw new IllegalStateException("The buffer queue entry has already been marked as consumed, so cannot be read from");
        }
        int length = this.dataLength();
        if (!this.isPublished() || length > this.maxDataLength() || length <= 0) {
            return new byte[0];
        }
        byte[] checksumBytes = new byte[CHECKSUM_BYTES];
        this.buf.position(32);
        this.buf.get(checksumBytes);
        byte[] data = new byte[length];
        this.buf.position(OFFSET_DATA);
        this.buf.get(data);
        if (!Arrays.equals(checksum.hashBytes(data).asBytes(), checksumBytes)) {
            return new byte[0];
        }
        return data;
    }

    public abstract void markConsumed();

    public abstract boolean isConsumed();

    public static int calculateEntryLength(int messageDataLength) {
        return OFFSET_DATA + messageDataLength;
    }

    public static int metadataOverhead() {
        return OFFSET_DATA;
    }
}

