/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.iris.bufferqueue.mmapped;

import com.flipkart.iris.bufferqueue.BufferQueue;
import com.flipkart.iris.bufferqueue.BufferQueueEntry;
import com.flipkart.iris.bufferqueue.mmapped.Helper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.validation.constraints.NotNull;

public class MappedBufferQueue
implements BufferQueue {
    private static final int MAX_BLOCK_SIZE_BYTES = 0x100000;
    public static final int DEFAULT_SYNC_INTERVAL_MILLIS = 10;
    private final File file;
    private final Integer blockSize;
    private final int headerSyncInterval;
    private final RandomAccessFile randomAccessFile;
    private final FileChannel fileChannel;
    @VisibleForTesting
    final MappedHeader mappedHeader;
    private final MappedEntries mappedEntries;
    private volatile Publisher publisher;
    private volatile Consumer consumer;
    public final AtomicLong consumeCursor = new AtomicLong(0L);
    public final AtomicLong publishCursor = new AtomicLong(0L);
    private boolean isClosed;

    private MappedBufferQueue(Builder builder) throws IOException {
        boolean fileExists = builder.file.exists();
        if (!fileExists && !builder.formatIfNotExists) {
            throw new FileNotFoundException("File doesn't exist and creation not requested");
        }
        long fileSize = fileExists ? builder.file.length() : (long)builder.fileSize;
        this.file = builder.file;
        MappedByteBuffer fileBuffer = Helper.mapFile(this.file, fileSize);
        this.randomAccessFile = new RandomAccessFile(this.file, "rw");
        this.fileChannel = this.randomAccessFile.getChannel();
        this.mappedHeader = this.getHeaderBuffer(fileBuffer);
        if (!fileExists) {
            Preconditions.checkArgument((builder.blockSize < 0x100000 ? 1 : 0) != 0, (String)"blockSize must be <= %s", (Object[])new Object[]{0x100000});
            this.mappedHeader.format(builder.blockSize);
        }
        this.blockSize = this.mappedHeader.blockSize();
        this.mappedEntries = this.getEntriesBuffer(fileBuffer);
        if (!fileExists) {
            this.mappedEntries.format();
        }
        this.consumeCursor.set(this.mappedHeader.readConsumeCursor());
        this.publishCursor.set(this.mappedHeader.readPublishCursor());
        this.headerSyncInterval = builder.headerSyncInterval;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    MappedBufferQueue.this.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private MappedHeader getHeaderBuffer(ByteBuffer fileBuffer) {
        ByteBuffer headerBuffer = MappedBufferQueue.subBuffer(fileBuffer, 0, 4096);
        return new MappedHeader(headerBuffer);
    }

    private MappedEntries getEntriesBuffer(ByteBuffer fileBuffer) {
        ByteBuffer entriesBuffer = MappedBufferQueue.subBuffer(fileBuffer, 4096);
        return new MappedEntries(entriesBuffer);
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferQueue.Publisher publisher() throws IllegalStateException, IOException {
        if (this.publisher == null) {
            MappedBufferQueue mappedBufferQueue = this;
            synchronized (mappedBufferQueue) {
                if (this.publisher == null) {
                    this.publisher = new Publisher();
                }
            }
        }
        return this.publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferQueue.Consumer consumer() throws IllegalStateException, IOException {
        if (this.consumer == null) {
            MappedBufferQueue mappedBufferQueue = this;
            synchronized (mappedBufferQueue) {
                if (this.consumer == null) {
                    this.consumer = new Consumer();
                }
            }
        }
        return this.consumer;
    }

    public synchronized void close() throws IOException {
        if (!this.isClosed) {
            if (this.publisher != null) {
                this.publisher.close();
            }
            if (this.consumer != null) {
                this.consumer.close();
            }
            this.randomAccessFile.close();
            this.fileChannel.close();
            this.isClosed = true;
        }
    }

    private void checkNotClosed() {
        if (this.isClosed) {
            throw new BufferQueue.ClosedBufferQueueException();
        }
    }

    public void printBufferSkeleton(String position) {
        System.out.println("Buffer Skeleton (" + position + ")");
        this.printBufferSkeleton();
    }

    void printBufferSkeleton() {
        System.out.println("ConsumeCursor: " + this.consumeCursor.get() + " PublishCursor: " + this.publishCursor.get() + " numBlocks: " + this.maxNumEntries());
    }

    public static int metadataOverhead() {
        return 10 + BufferQueueEntry.metadataOverhead();
    }

    public int maxDataLength() {
        return 127 * this.blockSize - MappedBufferQueue.metadataOverhead();
    }

    public long maxNumEntries() {
        return this.mappedEntries.capacity;
    }

    public long size() {
        return this.publishCursor.get() - this.consumeCursor.get();
    }

    public boolean isFull() {
        return this.size() == this.maxNumEntries();
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    private static ByteBuffer subBuffer(ByteBuffer buf, int start, int length) {
        try {
            buf = buf.duplicate();
            buf.position(start);
            buf = buf.slice();
            buf.limit(length);
            buf.rewind();
        }
        catch (IllegalArgumentException e) {
            System.out.println("start: " + start + " length: " + length + " buf.limit():" + buf.limit());
            throw e;
        }
        return buf;
    }

    private static ByteBuffer subBuffer(ByteBuffer buf, int start) {
        buf = buf.duplicate();
        buf.position(start);
        buf = buf.slice();
        buf.rewind();
        return buf;
    }

    public class MappedBufferQueueEntry
    extends BufferQueueEntry {
        @VisibleForTesting
        static final int OFFSET_NUM_BLOCKS = 0;
        @VisibleForTesting
        static final int OFFSET_STATUS = 1;
        @VisibleForTesting
        static final int OFFSET_CURSOR = 2;
        @VisibleForTesting
        static final int OFFSET_ENTRY = 10;
        private static final byte STATUS_UNCLAIMED = 0;
        private static final byte STATUS_CLAIMED_UNPUBLISHED = 1;
        private static final byte STATUS_PUBLISHED_UNCONSUMED = 2;
        private static final byte STATUS_CONSUMED = 3;
        private final ByteBuffer buf;

        public MappedBufferQueueEntry(ByteBuffer buf) {
            this.buf = buf;
            if (this.isPublishedUnconsumed() && this.readNumBlocks() > 0) {
                buf.limit(this.readNumBlocks() * MappedBufferQueue.this.blockSize);
            }
        }

        protected ByteBuffer getByteBuffer() {
            return MappedBufferQueue.subBuffer(this.buf, 10);
        }

        private byte maxBlocks() {
            return (byte)Math.min(127, this.buf.capacity() / this.readNumBlocks());
        }

        private long nextCursor() {
            return this.readCursor() + (long)this.readNumBlocks();
        }

        private MappedBufferQueueEntry format(long cursor) {
            this.writeNumBlocks((byte)1);
            this.writeCursor(cursor);
            this.writeStatus((byte)0);
            this.set("".getBytes());
            return this;
        }

        private MappedBufferQueueEntry markClaimedUnpublished(long cursor, byte numBlocks) {
            int length = numBlocks * MappedBufferQueue.this.blockSize;
            if (length > this.buf.capacity()) {
                throw new IllegalArgumentException("Asking for more blocks than supported by this entry");
            }
            this.writeStatus((byte)1);
            this.buf.limit(numBlocks * MappedBufferQueue.this.blockSize);
            this.writeNumBlocks(numBlocks);
            this.writeCursor(cursor);
            return this;
        }

        private boolean isUnclaimed() {
            return this.readStatus() == 0;
        }

        public boolean isClaimedUnpublished() {
            return this.readStatus() == 1;
        }

        public void markPublishedUnconsumed() {
            this.writeStatus((byte)2);
        }

        public boolean isPublishedUnconsumed() {
            return this.readStatus() == 2;
        }

        public void markConsumed() {
            this.writeStatus((byte)3);
        }

        public boolean isConsumed() {
            return this.readStatus() == 3;
        }

        private void markSkipped(long cursor, byte numBlocks) {
            this.markClaimedUnpublished(cursor, numBlocks);
            this.markConsumed();
        }

        byte readNumBlocks() {
            return this.buf.get(0);
        }

        void writeNumBlocks(byte numBlocks) {
            this.buf.put(0, numBlocks);
        }

        byte readStatus() {
            return this.buf.get(1);
        }

        void writeStatus(byte status) {
            this.buf.put(1, status);
        }

        @VisibleForTesting
        long readCursor() {
            return this.buf.getLong(2);
        }

        @VisibleForTesting
        void writeCursor(long cursor) {
            this.buf.putLong(2, cursor);
        }
    }

    public class MappedEntries {
        private final ByteBuffer entriesBuffer;
        public final int blockSize;
        public final int capacity;
        private final MappedBufferQueueEntry[] entries;

        MappedEntries(ByteBuffer entriesBuffer) {
            this.entriesBuffer = entriesBuffer;
            this.blockSize = MappedBufferQueue.this.mappedHeader.blockSize();
            this.capacity = entriesBuffer.limit() / this.blockSize;
            this.entries = new MappedBufferQueueEntry[this.capacity];
            for (int i = 0; i < this.capacity; ++i) {
                int offset = i % this.capacity * this.blockSize;
                this.entries[i] = new MappedBufferQueueEntry(MappedBufferQueue.subBuffer(entriesBuffer, offset, this.blockSize));
            }
        }

        public void format() {
            for (int i = 0; i < this.entries.length; ++i) {
                this.entries[i].format(i);
            }
        }

        @NotNull
        @VisibleForTesting
        MappedBufferQueueEntry getEntry(long cursor) {
            int index = (int)(cursor % (long)this.capacity);
            return this.entries[index];
        }
    }

    class MappedHeader {
        @VisibleForTesting
        static final int HEADER_LENGTH = 4096;
        @VisibleForTesting
        static final long OFFSET_BLOCK_SIZE = 0L;
        @VisibleForTesting
        static final long OFFSET_PUBLISH_CURSOR = 64L;
        @VisibleForTesting
        static final long OFFSET_CONSUME_CURSOR = 128L;
        private final ByteBuffer headerBuffer;
        private int maxDataLengthCached;
        private final ReadWriteLock publishCursorReadWritelock = new ReentrantReadWriteLock();
        private final Lock publishCursorReadLock = this.publishCursorReadWritelock.readLock();
        private final Lock publishCursorWriteLock = this.publishCursorReadWritelock.writeLock();
        private final ReadWriteLock consumeCursorReadWritelock = new ReentrantReadWriteLock();
        private final Lock consumeCursorReadLock = this.consumeCursorReadWritelock.readLock();
        private final Lock consumeCursorWriteLock = this.consumeCursorReadWritelock.writeLock();

        MappedHeader(ByteBuffer headerBuffer) {
            this.headerBuffer = headerBuffer;
        }

        void format(int maxDataLength) {
            this.headerBuffer.putInt(0, maxDataLength);
            this.headerBuffer.putLong(128, 0L);
            this.headerBuffer.putLong(64, 0L);
        }

        public int blockSize() {
            return this.headerBuffer.getInt(0);
        }

        FileLock lockPublishing() throws IOException {
            FileLock fileLock;
            try {
                fileLock = MappedBufferQueue.this.fileChannel.tryLock(64L, 64L, false);
            }
            catch (OverlappingFileLockException e) {
                throw new RuntimeException("MappedBufferQueue already open in this JVM.", e);
            }
            if (fileLock == null) {
                throw new RuntimeException("Another process already has the file open for publishing");
            }
            return fileLock;
        }

        FileLock lockConsumption() throws IOException {
            FileLock fileLock;
            try {
                fileLock = MappedBufferQueue.this.fileChannel.tryLock(128L, 64L, false);
            }
            catch (OverlappingFileLockException e) {
                throw new RuntimeException("MappedBufferQueue already open in this JVM.", e);
            }
            if (fileLock == null) {
                throw new RuntimeException("Another process already has the file open for publishing");
            }
            return fileLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long readPublishCursor() {
            try {
                this.publishCursorReadLock.lock();
                long l = this.headerBuffer.getLong(64);
                return l;
            }
            finally {
                this.publishCursorReadLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long commitPublishCursor(long n) {
            try {
                this.publishCursorWriteLock.lock();
                long currentValue = this.readPublishCursor();
                if (n > currentValue) {
                    this.headerBuffer.putLong(64, n);
                    long l = n;
                    return l;
                }
            }
            finally {
                this.publishCursorWriteLock.unlock();
            }
            return this.readPublishCursor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long readConsumeCursor() {
            try {
                this.consumeCursorReadLock.lock();
                long l = this.headerBuffer.getLong(128);
                return l;
            }
            finally {
                this.consumeCursorReadLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long commitConsumeCursor(long n) {
            try {
                this.consumeCursorWriteLock.lock();
                long currentValue = this.readConsumeCursor();
                if (n > currentValue) {
                    this.headerBuffer.putLong(128, n);
                    long l = n;
                    return l;
                }
            }
            finally {
                this.consumeCursorWriteLock.unlock();
            }
            return this.readConsumeCursor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Consumer
    implements BufferQueue.Consumer {
        private final FileLock fileLock;
        private final ScheduledExecutorService executorService;
        private volatile long publishCursorVal;

        public Consumer() throws IOException {
            this.publishCursorVal = MappedBufferQueue.this.publishCursor.get();
            this.fileLock = MappedBufferQueue.this.mappedHeader.lockConsumption();
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(MappedBufferQueue.class.getSimpleName() + "-" + Consumer.class.getSimpleName() + "-%d").build();
            this.executorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
            this.executorService.scheduleAtFixedRate(new Syncer(), MappedBufferQueue.this.headerSyncInterval, MappedBufferQueue.this.headerSyncInterval, TimeUnit.MILLISECONDS);
        }

        @Override
        public BufferQueue bufferQueue() {
            return MappedBufferQueue.this;
        }

        private long getPublishCursorVal() {
            if (MappedBufferQueue.this.publisher != null) {
                return MappedBufferQueue.this.publishCursor.get();
            }
            return this.publishCursorVal;
        }

        public void forwardConsumeCursor() {
            MappedBufferQueueEntry entry;
            long consumeCursorVal;
            long publishCursorVal = this.getPublishCursorVal();
            while ((consumeCursorVal = MappedBufferQueue.this.consumeCursor.get()) < publishCursorVal && (entry = MappedBufferQueue.this.mappedEntries.getEntry(consumeCursorVal)).readCursor() == consumeCursorVal && entry.isConsumed()) {
                MappedBufferQueue.this.consumeCursor.compareAndSet(consumeCursorVal, consumeCursorVal + (long)entry.readNumBlocks());
            }
        }

        public Optional<MappedBufferQueueEntry> peek() {
            MappedBufferQueueEntry entry;
            MappedBufferQueue.this.checkNotClosed();
            this.forwardConsumeCursor();
            long consumeCursorVal = MappedBufferQueue.this.consumeCursor.get();
            long publishCursorVal = this.getPublishCursorVal();
            if (consumeCursorVal < publishCursorVal && (entry = MappedBufferQueue.this.mappedEntries.getEntry(consumeCursorVal)).isPublishedUnconsumed()) {
                return Optional.of((Object)entry);
            }
            return Optional.absent();
        }

        public List<MappedBufferQueueEntry> peek(int n) {
            MappedBufferQueueEntry entry;
            long consumeCursorVal;
            MappedBufferQueue.this.checkNotClosed();
            ArrayList bufferQueueEntries = Lists.newArrayList();
            this.forwardConsumeCursor();
            long nextCursorVal = consumeCursorVal = MappedBufferQueue.this.consumeCursor.get();
            long publishCursorVal = this.getPublishCursorVal();
            int i = 0;
            while ((long)i < Math.min((long)n, publishCursorVal - consumeCursorVal) && !(entry = MappedBufferQueue.this.mappedEntries.getEntry(nextCursorVal)).isUnclaimed() && !entry.isClaimedUnpublished()) {
                if (entry.isPublishedUnconsumed()) {
                    bufferQueueEntries.add(entry);
                }
                nextCursorVal += (long)entry.readNumBlocks();
                ++i;
            }
            return bufferQueueEntries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<byte[]> consume() {
            Optional<MappedBufferQueueEntry> entry = this.peek();
            try {
                if (entry.isPresent()) {
                    Optional optional = Optional.of((Object)((MappedBufferQueueEntry)entry.get()).get());
                    return optional;
                }
                Optional optional = Optional.absent();
                return optional;
            }
            finally {
                if (entry.isPresent()) {
                    ((MappedBufferQueueEntry)entry.get()).markConsumed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<byte[]> consume(int n) {
            List<MappedBufferQueueEntry> entries = this.peek(n);
            ArrayList dataList = Lists.newArrayListWithCapacity((int)entries.size());
            for (MappedBufferQueueEntry entry : entries) {
                try {
                    dataList.add(entry.get());
                }
                finally {
                    entry.markConsumed();
                }
            }
            return dataList;
        }

        synchronized void syncCursor() {
            MappedBufferQueue.this.mappedHeader.commitConsumeCursor(MappedBufferQueue.this.consumeCursor.get());
            this.publishCursorVal = MappedBufferQueue.this.mappedHeader.readPublishCursor();
        }

        public synchronized void close() throws IOException {
            this.syncCursor();
            this.executorService.shutdownNow();
            this.fileLock.release();
        }

        class Syncer
        implements Runnable {
            Syncer() {
            }

            public void run() {
                Consumer.this.syncCursor();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Publisher
    implements BufferQueue.Publisher {
        private final FileLock fileLock;
        private final ScheduledExecutorService executorService;

        public Publisher() throws IOException {
            this.fileLock = MappedBufferQueue.this.mappedHeader.lockPublishing();
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(MappedBufferQueue.class.getSimpleName() + "-" + Publisher.class.getSimpleName() + "-%d").build();
            this.executorService = Executors.newSingleThreadScheduledExecutor(threadFactory);
            this.executorService.scheduleAtFixedRate(new Syncer(), MappedBufferQueue.this.headerSyncInterval, MappedBufferQueue.this.headerSyncInterval, TimeUnit.MILLISECONDS);
        }

        @Override
        public BufferQueue bufferQueue() {
            return MappedBufferQueue.this;
        }

        public Optional<MappedBufferQueueEntry> claim(byte numBlocks) {
            long n;
            MappedBufferQueue.this.checkNotClosed();
            if (MappedBufferQueue.this.publishCursor.get() - MappedBufferQueue.this.consumeCursor.get() >= MappedBufferQueue.this.maxNumEntries()) {
                return Optional.absent();
            }
            do {
                MappedBufferQueueEntry entry;
                block5: {
                    int i = 0;
                    do {
                        n = MappedBufferQueue.this.publishCursor.get();
                        MappedBufferQueueEntry entry2 = MappedBufferQueue.this.mappedEntries.getEntry(n);
                        if (entry2.maxBlocks() >= numBlocks) break block5;
                        if (!MappedBufferQueue.this.publishCursor.compareAndSet(n, n + (long)entry2.maxBlocks())) continue;
                        entry2.markSkipped(n, entry2.maxBlocks());
                        break block5;
                    } while (i++ < 10);
                    return Optional.absent();
                }
                for (long i = n; i < n + (long)numBlocks; i += (long)entry.readNumBlocks()) {
                    entry = MappedBufferQueue.this.mappedEntries.getEntry(i);
                    if (!entry.isClaimedUnpublished() && !entry.isPublishedUnconsumed()) continue;
                    return Optional.absent();
                }
            } while (!MappedBufferQueue.this.publishCursor.compareAndSet(n, n + (long)numBlocks));
            MappedBufferQueueEntry entry = MappedBufferQueue.this.mappedEntries.getEntry(n);
            if (entry.maxBlocks() < numBlocks) {
                return Optional.absent();
            }
            entry.markClaimedUnpublished(n, numBlocks);
            return Optional.of((Object)entry);
        }

        public Optional<MappedBufferQueueEntry> claim() {
            return this.claim((byte)1);
        }

        public Optional<MappedBufferQueueEntry> claimFor(int dataSize) {
            if (dataSize > MappedBufferQueue.this.maxDataLength()) {
                throw new IllegalArgumentException("Cannot create buffer for requested data size in this BufferQueue");
            }
            int dataPlusMetadataSize = dataSize + MappedBufferQueue.metadataOverhead();
            byte numBlocks = (byte)(dataPlusMetadataSize / MappedBufferQueue.this.blockSize + (dataPlusMetadataSize % MappedBufferQueue.this.blockSize != 0 ? 1 : 0));
            return this.claim(numBlocks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean publish(byte[] data) throws BufferOverflowException {
            Optional<MappedBufferQueueEntry> entry = this.claimFor(data.length);
            if (!entry.isPresent()) {
                return false;
            }
            try {
                ((MappedBufferQueueEntry)entry.get()).set(data);
            }
            finally {
                ((MappedBufferQueueEntry)entry.get()).markPublishedUnconsumed();
            }
            return true;
        }

        synchronized void syncCursor() {
            MappedBufferQueue.this.mappedHeader.commitPublishCursor(MappedBufferQueue.this.publishCursor.get());
        }

        public synchronized void close() throws IOException {
            this.syncCursor();
            this.executorService.shutdownNow();
            this.fileLock.release();
        }

        class Syncer
        implements Runnable {
            Syncer() {
            }

            public void run() {
                Publisher.this.syncCursor();
            }
        }
    }

    public static class Builder {
        private File file;
        private int headerSyncInterval = 10;
        private boolean formatIfNotExists = false;
        private int blockSize;
        private int fileSize;

        public Builder(File file) {
            this.file = file;
        }

        public Builder headerSyncInterval(int headerSyncInterval) {
            this.headerSyncInterval = headerSyncInterval;
            return this;
        }

        public Builder formatIfNotExists(int fileSize, int blockSize) {
            Preconditions.checkArgument((blockSize > MappedBufferQueue.metadataOverhead() ? 1 : 0) != 0, (Object)("blockSize must be greater than " + MappedBufferQueue.metadataOverhead() + " bytes"));
            this.formatIfNotExists = true;
            this.blockSize = blockSize;
            this.fileSize = fileSize;
            return this;
        }

        public MappedBufferQueue build() throws IOException {
            return new MappedBufferQueue(this);
        }
    }
}

