/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.task;

import com.flipkart.hydra.composer.Composer;
import com.flipkart.hydra.composer.DefaultComposer;
import com.flipkart.hydra.composer.exception.ComposerEvaluationException;
import com.flipkart.hydra.composer.exception.ComposerInstantiationException;
import com.flipkart.hydra.task.DefaultTask;
import com.flipkart.hydra.task.entities.WrapperCallable;
import com.flipkart.hydra.task.exception.BadCallableException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class DefaultMultiTask
extends DefaultTask {
    private final Composer loopComposer;
    private final ExecutorService executor;

    public DefaultMultiTask(ExecutorService executor, Class<? extends Callable> callableClass, Object loopOverContext, Object context) throws ComposerInstantiationException {
        this(executor, callableClass, context, loopOverContext, false);
    }

    public DefaultMultiTask(ExecutorService executor, Class<? extends Callable> callableClass, Object context, Object loopOverContext, boolean isAlreadyParsed) throws ComposerInstantiationException {
        this(executor, callableClass, (Composer)new DefaultComposer(context, isAlreadyParsed), (Composer)new DefaultComposer(loopOverContext, isAlreadyParsed));
    }

    public DefaultMultiTask(ExecutorService executor, Class<? extends Callable> callableClass, Composer composer, Composer loopComposer) {
        super(callableClass, composer);
        this.executor = executor;
        this.loopComposer = loopComposer;
    }

    @Override
    public Callable<Object> getCallable(Map<String, Object> values) throws BadCallableException {
        if (this.loopComposer == null) {
            return super.getCallable(values);
        }
        try {
            return new WrapperCallable(this.executor, this.callableClass, this.loopComposer, this.composer, values);
        }
        catch (ComposerEvaluationException | NoSuchMethodException e) {
            throw new BadCallableException("Unable to execute callable", e);
        }
    }

    @Override
    public List<String> getDependencies() {
        HashSet<String> dependencies = new HashSet<String>(super.getDependencies());
        if (this.loopComposer != null) {
            dependencies.addAll(this.loopComposer.getDependencies());
        }
        return new ArrayList<String>(dependencies);
    }
}

