/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.expression;

import com.flipkart.hydra.expression.Expression;
import com.flipkart.hydra.expression.exception.ExpressionEvaluationException;
import com.flipkart.hydra.expression.exception.ExpressionParseException;
import com.flipkart.hydra.expression.utils.ExpressionEvaluator;
import com.flipkart.hydra.expression.utils.ExpressionParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultExpression
implements Expression {
    private final String expression;
    private final List operands;
    private final List<String> dependencies;
    private final boolean isOptional;

    public DefaultExpression(String expression) throws ExpressionParseException {
        expression = expression.replaceAll("\\s", "");
        this.isOptional = expression.startsWith("#");
        this.expression = expression.substring(this.isOptional ? 1 : 0);
        this.operands = ExpressionParser.parse(this.expression);
        this.dependencies = this.findDependencies(this.operands);
    }

    @Override
    public Object calculate(Map<String, Object> values) throws ExpressionEvaluationException {
        Object value = ExpressionEvaluator.evaluate(this.operands, values);
        if (!this.isOptional && value == null) {
            throw new ExpressionEvaluationException("Null value found for non-optional expression - " + this.expression);
        }
        return value;
    }

    @Override
    public List<String> getDependencies() {
        return this.dependencies;
    }

    private List<String> findDependencies(List operands) {
        ArrayList<String> dependencies = new ArrayList<String>();
        for (Object value : operands) {
            String stringValue;
            if (value instanceof List) {
                dependencies.addAll(this.findDependencies((List)value));
                continue;
            }
            if (!(value instanceof String) || !(stringValue = (String)value).startsWith("$") || stringValue.startsWith("$__")) continue;
            dependencies.add(stringValue.substring(1));
        }
        return dependencies;
    }
}

