/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.expression.utils;

import com.flipkart.hydra.expression.exception.ExpressionEvaluationException;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExpressionEvaluator {
    public static Object evaluate(List operands, Map<String, Object> values) throws ExpressionEvaluationException {
        Object response = null;
        Iterator i$ = operands.iterator();
        while (i$.hasNext()) {
            Object operand;
            Object calculatedOperand = operand = i$.next();
            if (operand instanceof List) {
                calculatedOperand = ExpressionEvaluator.evaluate((List)operand, values);
            }
            if ((response = ExpressionEvaluator.calculateOperandResponse(calculatedOperand, values, response)) != null) continue;
            break;
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object calculateOperandResponse(Object operand, Map<String, Object> values, Object response) throws ExpressionEvaluationException {
        if (response == null) {
            if (!(operand instanceof String)) return operand;
            String stringOperand = (String)operand;
            if (!stringOperand.startsWith("$")) return response;
            String variable = stringOperand.substring(1);
            return values.get(variable);
        }
        if (response instanceof List) {
            if (!(operand instanceof Integer)) throw new ExpressionEvaluationException("Invalid operand - " + operand);
            return ((List)response).get((Integer)operand);
        }
        if (response instanceof Map) {
            Object possibleResponse = ((Map)response).get(operand);
            return possibleResponse != null ? possibleResponse : ((Map)response).get(String.valueOf(operand));
        }
        if (response instanceof String) {
            if (!(operand instanceof Integer)) throw new ExpressionEvaluationException("Invalid operand - " + operand);
            return Character.valueOf(((String)response).charAt((Integer)operand));
        }
        if (response instanceof Integer) throw new ExpressionEvaluationException("Invalid operand - " + operand);
        if (response instanceof Double) {
            throw new ExpressionEvaluationException("Invalid operand - " + operand);
        }
        if (operand instanceof String) return ExpressionEvaluator.getFieldValue((String)operand, response);
        throw new ExpressionEvaluationException("Invalid operand - " + operand);
    }

    private static Object getFieldValue(String operand, Object response) throws ExpressionEvaluationException {
        for (Class<?> klass = response.getClass(); klass != null && klass != Object.class; klass = klass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = klass.getDeclaredFields()) {
                if (!field.getName().equals(operand)) continue;
                try {
                    Field declaredField = klass.getDeclaredField(operand);
                    declaredField.setAccessible(true);
                    return declaredField.get(response);
                }
                catch (IllegalAccessException | NoSuchFieldException ignored) {
                    // empty catch block
                }
            }
        }
        throw new ExpressionEvaluationException("No field named '" + operand + "' exists for " + response.getClass().getName());
    }
}

