/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.hydra.expression.utils;

import com.flipkart.hydra.expression.exception.ExpressionParseException;
import java.util.ArrayList;
import java.util.List;

public class ExpressionParser {
    public static List parse(final String expression) throws ExpressionParseException {
        if (expression.startsWith("$")) {
            return ExpressionParser.parseExpression(expression);
        }
        return new ArrayList<Object>(){
            {
                this.add(ExpressionParser.getValue(expression));
            }
        };
    }

    private static List parseExpression(String expression) throws ExpressionParseException {
        ArrayList<Object> operands = new ArrayList<Object>();
        String token = "$";
        char c = '~';
        for (int i = 1; i < expression.length(); ++i) {
            c = expression.charAt(i);
            if (ExpressionParser.isAllowedChar(c)) {
                token = token + c;
                continue;
            }
            if (c == '[' || c == '.') {
                if ("".equals(token) || "$".equals(token)) {
                    throw new ExpressionParseException(expression, "a-z A-Z 0-9 _ . [", c, i + 1);
                }
                operands.add(token);
                token = "";
                int brackets = 0;
                if (c != 91) continue;
                while (i < expression.length()) {
                    c = expression.charAt(i);
                    switch (c) {
                        case '[': {
                            ++brackets;
                            break;
                        }
                        case ']': {
                            --brackets;
                            break;
                        }
                        default: {
                            token = token + c;
                        }
                    }
                    if (brackets == 0) {
                        operands.add(ExpressionParser.parseSubExpression(expression, token, i + 1));
                        token = "";
                        break;
                    }
                    ++i;
                }
                if (++i >= expression.length() || (c = expression.charAt(i)) == 46) continue;
                throw new ExpressionParseException(expression, ".", c, i + 1);
            }
            throw new ExpressionParseException(expression, "a-z A-Z 0-9 _ . [ ", c, i + 1);
        }
        if ("".equals(token) || "$".equals(token)) {
            if (c != ']') {
                throw new ExpressionParseException(expression, "a-z A-Z 0-9 _", "EOF", expression.length());
            }
        } else {
            operands.add(token);
        }
        return operands;
    }

    private static List parseSubExpression(String expression, String subExpression, int position) throws ExpressionParseException {
        try {
            return ExpressionParser.parse(subExpression);
        }
        catch (ExpressionParseException e) {
            throw new ExpressionParseException(expression, subExpression, position);
        }
    }

    private static Object getValue(String expression) {
        try {
            return Integer.parseInt(expression);
        }
        catch (NumberFormatException e1) {
            try {
                return Double.parseDouble(expression);
            }
            catch (NumberFormatException e2) {
                return expression;
            }
        }
    }

    private static boolean isAllowedChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '_';
    }
}

